/*
 * Decompiled with CFR 0.152.
 */
package controlador;

import controlador.Acao;
import controlador.BaseControlador;
import controlador.Configuer;
import controlador.Controler;
import controlador.Diagrama;
import controlador.ISuperControler;
import controlador.Mostrador;
import controlador.QuadroDeEdicao;
import controlador.Selecionador;
import controlador.apoios.GuardaPadraoBrM;
import controlador.apoios.Historico;
import controlador.editores.DrawerEditor;
import controlador.editores.LegendaEditor;
import controlador.inspector.Inspector;
import controlador.inspector.InspectorDicas;
import controlador.inspector.InspectorExtenderEditor;
import controlador.inspector.InspectorItemBase;
import controlador.inspector.InspectorProperty;
import desenho.Elementar;
import desenho.FormaElementar;
import desenho.formas.Desenhador;
import desenho.formas.Legenda;
import desenho.preDiagrama.iBaseDrawer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import principal.Aplicacao;
import util.Arquivo;
import util.BrLogger;
import util.CopFormatacao;
import util.Dialogos;
import util.ImageGenerate;
import util.Utilidades;

public class Editor
extends BaseControlador
implements KeyListener {
    public Diagrama diagramaAtual;
    private Selecionador multSel = null;
    public static final Configuer fromConfiguracao = new Configuer();
    private static Controler _fromControler = null;
    private JScrollPane parente = null;
    private Mostrador showDiagramas = null;
    public CopFormatacao CopiadorFormatacao = new CopFormatacao();
    private QuadroDeEdicao box;
    private ISuperControler FramePrincipal;
    private boolean shiftDown = false;
    private boolean altDown = false;
    private boolean controlDown = false;
    private boolean mostrarDimensoesAoMover = true;
    private boolean showGrid = false;
    private int gridWidth = 20;
    private Diagrama.TipoDeDiagrama tipoDefault = Diagrama.TipoDeDiagrama.tpEap;
    private boolean propagueDeleteToLines = true;
    private Inspector editorConfig = null;
    private boolean salvarLocation = true;
    public final double[] zoonsd = new double[]{0.125, 0.25, 0.5, 0.75, 1.0, 1.25, 1.5, 1.75, 2.0, 3.0, 4.0, 5.0};
    private JLabel lblZoom = null;
    private int lastTreeCount = -1;
    private ArrayList<String> recentes = new ArrayList();
    private JMenu MenuRecente = null;
    private Inspector outroInspector = null;
    private iParaOutrosInspectors falsoEditor = null;
    private final Controler controler = new Controler(this);
    private InspectorDicas Dicas = null;
    private Inspector InspectorEditor = null;
    private transient boolean scrolling = false;
    private final Historico historicos = new Historico(this);
    private transient LegendaEditor editorLegenda = null;
    private final ArrayList<byte[]> autoSave = new ArrayList();
    private boolean autoSaveAtivo = false;
    private boolean autoSaveIniciado = false;
    private int autoSaveInterval = 5;
    private boolean doneAutoSave = true;
    private Temporizador tempoAs;
    private JLabel lblStatus = null;
    private boolean Ancorador = false;
    private boolean mostrarIDs = false;
    private boolean mostrarTooltips = false;
    private boolean apagarTextoAoEditar = true;

    public static Controler fromControler() {
        return _fromControler;
    }

    public Editor() {
        this.setDoubleBuffered(true);
        this.initBox();
        this.historicos.add(this.diagramaAtual);
        this.setFocusable(true);
        this.addKeyListener(this);
        _fromControler = this.controler;
        this.setFocusTraversalKeysEnabled(false);
        KeyStroke key_crtl = KeyStroke.getKeyStroke(17, 128);
        KeyStroke key_crtl_up = KeyStroke.getKeyStroke(17, 0, true);
        KeyStroke key_crtlEshift = KeyStroke.getKeyStroke(17, 192, false);
        KeyStroke key_shiftEcrtl = KeyStroke.getKeyStroke(16, 192, false);
        KeyStroke key_crtlEshift_up = KeyStroke.getKeyStroke(17, 64, true);
        KeyStroke key_shiftEcrtl_up = KeyStroke.getKeyStroke(16, 128, true);
        KeyStroke key_shift = KeyStroke.getKeyStroke(16, 64);
        KeyStroke key_shift_up = KeyStroke.getKeyStroke(16, 0, true);
        KeyStroke key_alt = KeyStroke.getKeyStroke(18, 512);
        KeyStroke key_alt_up = KeyStroke.getKeyStroke(18, 0, true);
        String ac_crtl = "AC_CRTL";
        String ac_crtl_up = "AC_CRTL_UP";
        String ac_crtlEshift = "AC_CRTLeSHIFT";
        String ac_shiftEcrtl = "AC_SHIFTeCRTL";
        String ac_crtlEshift_up = "AC_CRTLeSHIFT_UP";
        String ac_shiftEcrtl_up = "AC_SHIFTeCRTL_UP";
        String ac_shift = "AC_SHIFT";
        String ac_shift_up = "AC_SHIFT_UP";
        String ac_alt = "AC_ALT";
        String ac_alt_up = "AC_ALT_UP";
        InputMap inputMap = this.getInputMap(2);
        inputMap.put(key_crtl, "AC_CRTL");
        inputMap.put(key_crtl_up, "AC_CRTL_UP");
        inputMap.put(key_crtlEshift, "AC_CRTLeSHIFT");
        inputMap.put(key_shiftEcrtl, "AC_SHIFTeCRTL");
        inputMap.put(key_crtlEshift_up, "AC_CRTLeSHIFT_UP");
        inputMap.put(key_shiftEcrtl_up, "AC_SHIFTeCRTL_UP");
        inputMap.put(key_shift, "AC_SHIFT");
        inputMap.put(key_shift_up, "AC_SHIFT_UP");
        inputMap.put(key_alt, "AC_ALT");
        inputMap.put(key_alt_up, "AC_ALT_UP");
        AbstractAction al_crtl = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Editor.this.controlDown = true;
            }
        };
        AbstractAction al_crtl_up = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Editor.this.controlDown = false;
            }
        };
        AbstractAction al_crtlEshift = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Editor.this.controlDown = true;
                Editor.this.shiftDown = true;
            }
        };
        AbstractAction al_shiftEcrtl = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Editor.this.controlDown = true;
                Editor.this.shiftDown = true;
            }
        };
        AbstractAction al_crtlEshift_up = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Editor.this.controlDown = false;
            }
        };
        AbstractAction al_shiftEcrtl_up = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Editor.this.shiftDown = false;
            }
        };
        AbstractAction al_shift = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Editor.this.shiftDown = true;
            }
        };
        AbstractAction al_shift_up = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Editor.this.shiftDown = false;
            }
        };
        AbstractAction al_alt = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Editor.this.altDown = true;
            }
        };
        AbstractAction al_alt_up = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!Editor.this.altDown) {
                    Editor.this.controlDown = false;
                }
                Editor.this.altDown = false;
            }
        };
        ActionMap actionMap = this.getActionMap();
        actionMap.put("AC_CRTL", al_crtl);
        actionMap.put("AC_CRTLeSHIFT", al_crtlEshift);
        actionMap.put("AC_SHIFTeCRTL", al_shiftEcrtl);
        actionMap.put("AC_CRTLeSHIFT_UP", al_crtlEshift_up);
        actionMap.put("AC_SHIFTeCRTL_UP", al_shiftEcrtl_up);
        actionMap.put("AC_CRTL_UP", al_crtl_up);
        actionMap.put("AC_SHIFT", al_shift);
        actionMap.put("AC_SHIFT_UP", al_shift_up);
        actionMap.put("AC_ALT", al_alt);
        actionMap.put("AC_ALT_UP", al_alt_up);
        this.setActionMap(actionMap);
    }

    public int getMargem() {
        return this.box.getEditorMargem();
    }

    private void initBox() {
        this.box = new QuadroDeEdicao(this);
        this.setSize(2 * this.box.getEditorMargem() + this.box.getEditorAtualWidth(), 2 * this.box.getEditorMargem() + this.box.getEditorAtualHeigth());
        this.setPreferredSize(this.getSize());
        this.setLayout(null);
        this.add(this.box);
        this.box.setSize(this.box.getEditorAtualWidth(), this.box.getEditorAtualHeigth());
        this.box.setPreferredSize(this.box.getSize());
        this.box.setLocation(this.box.getEditorMargem(), this.box.getEditorMargem());
        this.PreCarregueConfig();
        this.diagramaAtual = this.Novo(null);
        this.prepareDiagramaAtual();
    }

    public void CarregueConfig() {
        this.PerformInspectorCfg();
    }

    private void PreCarregueConfig() {
        try {
            String a = fromConfiguracao.getValor("cfg.mostrardimensoesaomover");
            boolean sn = a.equals("cfg.mostrardimensoesaomover") ? true : Boolean.valueOf(a);
            this.setMostrarDimensoesAoMover(sn);
            a = fromConfiguracao.getValor("cfg.mostrargrade");
            sn = a.equals("cfg.mostrargrade") ? true : Boolean.valueOf(a);
            this.setShowGrid(sn);
            a = fromConfiguracao.getValor("cfg.ancorador");
            sn = a.equals("cfg.ancorador") ? true : Boolean.valueOf(a);
            this.setAncorador(sn);
            a = fromConfiguracao.getValor("cfg.propaguedeletetolines");
            sn = a.equals("cfg.propaguedeletetolines") ? true : Boolean.valueOf(a);
            this.setPropagueDeleteToLines(sn);
            a = fromConfiguracao.getValor("cfg.location.salvar");
            sn = a.equals("cfg.location.salvar") ? false : Boolean.valueOf(a);
            this.setSalvarLocation(sn);
            a = fromConfiguracao.getValor("cfg.gradelargura");
            if (a.equals("cfg.gradelargura")) {
                a = "20";
            }
            int tmp = Integer.valueOf(a);
            this.setGridWidth(tmp);
            a = fromConfiguracao.getValor("cfg.tipodefault");
            if (a.equals("cfg.tipodefault")) {
                a = "0";
            }
            tmp = Integer.valueOf(a);
            this.setTipoDefaultInt(tmp);
            a = fromConfiguracao.getValor("cfg.mostrarids");
            sn = a.equals("cfg.mostrarids") ? false : Boolean.valueOf(a);
            this.setMostrarIDs(sn);
            a = fromConfiguracao.getValor("cfg.mostrartooltips");
            sn = a.equals("cfg.mostrartooltips") ? false : Boolean.valueOf(a);
            this.setMostrarTooltips(sn);
            a = fromConfiguracao.getValor("cfg.autosalvarintervalo");
            if (a.equals("cfg.autosalvarintervalo")) {
                a = "5";
            }
            tmp = Integer.valueOf(a);
            this.PreInicieAutoSave(tmp);
        }
        catch (NumberFormatException e) {
            BrLogger.Logger("ERROR_LOAD_CFGFILE", e.getMessage());
        }
    }

    public QuadroDeEdicao getBox() {
        return this.box;
    }

    public void setBox(QuadroDeEdicao box) {
        this.box = box;
    }

    public void AjusteTamanho() {
        this.setSize(2 * this.box.getEditorMargem() + this.box.getEditorAtualWidth(), 2 * this.box.getEditorMargem() + this.box.getEditorAtualHeigth());
        this.setPreferredSize(this.getSize());
        this.box.setSize(this.box.getEditorAtualWidth(), this.box.getEditorAtualHeigth());
        this.box.setPreferredSize(this.box.getSize());
    }

    public ISuperControler getFramePrincipal() {
        return this.FramePrincipal;
    }

    public void setFramePrincipal(ISuperControler FramePrincipal2) {
        this.FramePrincipal = FramePrincipal2;
    }

    @Override
    public void keyTyped(KeyEvent e) {
        String letras = " !@#$%&*()-_+='\"[{]},.;:<>|\\/?\u00ac\u00a3\u00a2\u00a7\u00aa\u00ba}";
        if (this.diagramaAtual.getSelecionado() != null && (Character.isLetterOrDigit(e.getKeyChar()) || letras.indexOf(e.getKeyChar()) > -1)) {
            InspectorItemBase ex = this.getInspectorEditor().FindByProperty("setTexto");
            if (ex == null && this.diagramaAtual.getTipo() == Diagrama.TipoDeDiagrama.tpLogico) {
                ex = this.getInspectorEditor().FindByProperty("Campo.setTexto");
            }
            if (ex != null && ex.CanEdit()) {
                InspectorExtenderEditor tmx;
                if (ex.getOndeEditar() instanceof JTextField) {
                    this.getInspectorEditor().PerformSelect(ex);
                    ex.getOndeEditar().requestFocus();
                    ((JTextField)ex.getOndeEditar()).setText(this.isApagarTextoAoEditar() ? String.valueOf(e.getKeyChar()) : ex.getValor() + String.valueOf(e.getKeyChar()));
                    e.consume();
                } else if (ex.getOndeEditar() instanceof InspectorExtenderEditor && (tmx = (InspectorExtenderEditor)ex.getOndeEditar()).getAcaoTipo() == InspectorExtenderEditor.TipoDeAcao.tpAcaoDlgTexto) {
                    this.getInspectorEditor().PerformSelect(ex);
                    tmx.RunDlg(this.isApagarTextoAoEditar() ? String.valueOf(e.getKeyChar()) : ex.getValor() + String.valueOf(e.getKeyChar()));
                    this.shiftDown = false;
                    this.altDown = false;
                    this.controlDown = false;
                    e.consume();
                }
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.diagramaAtual != null) {
            switch (e.getKeyCode()) {
                case 10: 
                case 27: 
                case 37: 
                case 38: 
                case 39: 
                case 40: {
                    this.diagramaAtual.ProcesseTeclas(e);
                    break;
                }
                case 127: {
                    if (this.diagramaAtual == null) break;
                    this.diagramaAtual.deleteSelecao();
                    e.consume();
                    break;
                }
                case 9: {
                    if (e.isControlDown()) {
                        if (e.isShiftDown()) {
                            if (!this.diagramaAtual.SelecioneAnterior()) break;
                            e.consume();
                            break;
                        }
                        if (!this.diagramaAtual.SelecioneProximo()) break;
                        e.consume();
                        break;
                    }
                    this.transferFocus();
                }
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    public boolean isShiftDown() {
        return this.shiftDown;
    }

    public void setShiftDown(boolean shiftDown) {
        this.shiftDown = shiftDown;
    }

    public boolean isAltDown() {
        return this.altDown;
    }

    public void setAltDown(boolean altDown) {
        this.altDown = altDown;
    }

    public boolean isControlDown() {
        return this.controlDown;
    }

    public void setControlDown(boolean controlDown) {
        this.controlDown = controlDown;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.diagramaAtual == null) {
            return;
        }
        RenderingHints renderHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        renderHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        Graphics2D Canvas = (Graphics2D)g;
        Canvas.addRenderingHints(renderHints);
        Canvas.setPaint(Color.BLACK);
        BasicStroke stroke = new BasicStroke(2.0f, 2, 0);
        Canvas.setStroke(stroke);
        Canvas.drawRect(this.box.getLocation().x, this.box.getLocation().y, this.box.getWidth(), this.box.getHeight());
        Canvas.setPaint(Color.GRAY);
        Canvas.drawRect(this.box.getLocation().x + 1, this.box.getLocation().y + 1, this.box.getWidth(), this.box.getHeight());
    }

    public Selecionador getMultSel() {
        return this.multSel;
    }

    public void FinishMultiSel() {
        if (this.multSel == null) {
            return;
        }
        this.diagramaAtual.Remove(this.multSel, false);
        this.getMultSel().Finish();
    }

    public void InitMultiSel(Point _local) {
        this.multSel = new Selecionador(this.diagramaAtual);
        this.getMultSel().Init(_local);
    }

    public Diagrama.TipoDeDiagrama getTipoDefault() {
        return this.tipoDefault;
    }

    public void setTipoDefault(Diagrama.TipoDeDiagrama tipoDefault) {
        this.tipoDefault = tipoDefault;
    }

    public void setTipoDefaultInt(int tipoDefault) {
        if (tipoDefault < Diagrama.TipoDeDiagrama.values().length && tipoDefault > -1) {
            this.tipoDefault = Diagrama.TipoDeDiagrama.values()[tipoDefault];
        }
    }

    public boolean isPropagueDeleteToLines() {
        return this.propagueDeleteToLines;
    }

    public void setPropagueDeleteToLines(boolean propagueDeleteToLines) {
        this.propagueDeleteToLines = propagueDeleteToLines;
    }

    public int getGridWidth() {
        return this.gridWidth;
    }

    public void setGridWidth(int GridWidth) {
        if (GridWidth < 0 || GridWidth > 600) {
            GridWidth = 20;
        }
        this.gridWidth = GridWidth;
        this.repaint();
    }

    public boolean isShowGrid() {
        return this.showGrid;
    }

    public void setShowGrid(boolean showGrid) {
        this.showGrid = showGrid;
        this.repaint();
    }

    public boolean isMostrarDimensoesAoMover() {
        return this.mostrarDimensoesAoMover;
    }

    public void setMostrarDimensoesAoMover(boolean mostrarDimensoesAoMover) {
        this.mostrarDimensoesAoMover = mostrarDimensoesAoMover;
    }

    public Inspector getEditorConfig() {
        return this.editorConfig;
    }

    public void setEditorConfig(Inspector editorConfig) {
        this.editorConfig = editorConfig;
        if (editorConfig != null) {
            editorConfig.setEditor(this);
        }
    }

    private ArrayList<InspectorProperty> GenerateProperty() {
        ArrayList<InspectorProperty> res = new ArrayList<InspectorProperty>();
        res.add(InspectorProperty.PropertyFactorySeparador("cfg"));
        res.add(InspectorProperty.PropertyFactorySN("cfg.mostrardimensoesaomover", "setMostrarDimensoesAoMover", this.isMostrarDimensoesAoMover()));
        ArrayList<String> dias = new ArrayList<String>();
        for (Diagrama.TipoDeDiagrama tp : Diagrama.TipoDeDiagrama.values()) {
            String tmp = fromConfiguracao.getValor("Inspector.lst.tipodiagrama." + tp.name().substring(2).toLowerCase());
            dias.add(tmp);
        }
        res.add(InspectorProperty.PropertyFactoryMenu("cfg.tipodefault", "setTipoDefaultInt", this.getTipoDefault().ordinal(), dias));
        res.add(InspectorProperty.PropertyFactorySeparador("desenho"));
        res.add(InspectorProperty.PropertyFactorySN("cfg.propaguedeletetolines", "setPropagueDeleteToLines", this.isPropagueDeleteToLines()));
        res.add(InspectorProperty.PropertyFactorySN("cfg.mostrargrade", "setShowGrid", this.isShowGrid()).AddCondicaoForTrue(new String[]{"setGridWidth"}));
        res.add(InspectorProperty.PropertyFactoryNumero("cfg.gradelargura", "setGridWidth", this.getGridWidth()));
        res.add(InspectorProperty.PropertyFactorySN("cfg.location.salvar", "setSalvarLocation", this.isSalvarLocation()));
        res.add(InspectorProperty.PropertyFactoryNumero("cfg.autosalvarintervalo", "setAutoSaveInterval", this.getAutoSaveInterval()));
        res.add(InspectorProperty.PropertyFactorySeparador("cfg.exibicao", true));
        res.add(InspectorProperty.PropertyFactorySN("cfg.ancorador", "setAncorador", this.isAncorador()));
        res.add(InspectorProperty.PropertyFactorySN("cfg.mostrarids", "setMostrarIDs", this.isMostrarIDs()));
        res.add(InspectorProperty.PropertyFactorySN("cfg.mostrartooltips", "setMostrarTooltips", this.isMostrarTooltips()));
        res.add(InspectorProperty.PropertyFactorySeparador("cfg.edicao", true));
        res.add(InspectorProperty.PropertyFactorySN("cfg.apagartextoaoeditar", "setApagarTextoAoEditar", this.isApagarTextoAoEditar()));
        return res;
    }

    public void setSalvarLocation(boolean sn) {
        this.salvarLocation = sn;
    }

    public boolean isSalvarLocation() {
        return this.salvarLocation;
    }

    private void PerformInspectorCfg() {
        this.setTextoDica(null, "");
        this.getEditorConfig().Carrege(this.GenerateProperty());
    }

    private boolean AceitaEdicao(InspectorProperty propriedade, String valor) {
        Editor ed = this;
        Class[] par2 = new Class[1];
        Object[] vl = new Object[1];
        try {
            switch (propriedade.tipo) {
                case tpBooleano: {
                    par2[0] = Boolean.TYPE;
                    vl[0] = Boolean.parseBoolean(valor);
                    break;
                }
                case tpCor: {
                    par2[0] = Color.class;
                    vl[0] = Utilidades.StringToColor(valor);
                    break;
                }
                case tpMenu: {
                    par2[0] = Integer.TYPE;
                    int p = Integer.parseInt(valor);
                    vl[0] = p;
                    break;
                }
                case tpNumero: {
                    par2[0] = Integer.TYPE;
                    int tmp = Integer.parseInt(valor);
                    vl[0] = tmp;
                    break;
                }
                default: {
                    par2[0] = String.class;
                    vl[0] = valor;
                }
            }
            Class<?> cl = ed.getClass();
            Method mthd = cl.getMethod(propriedade.property, par2);
            mthd.invoke((Object)ed, vl);
            if (!propriedade.configuracaoStr.isEmpty()) {
                fromConfiguracao.SetAndSaveIfNeed(propriedade.configuracaoStr, valor);
            }
            this.PerformInspectorCfg();
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            BrLogger.Logger("ERROR_SET_PROPERTY", e.getMessage());
            return false;
        }
        return true;
    }

    public double getZoom() {
        return this.box.getZoom();
    }

    public void setZoom(double zoom) {
        if (zoom < 0.1 || zoom > 8.0) {
            zoom = 1.0;
        }
        this.box.setZoom(zoom);
        this.AjusteTamanho();
        if (this.diagramaAtual != null) {
            this.diagramaAtual.setZoom(zoom);
            this.diagramaAtual.PerformInspector();
            if (this.lblZoom != null) {
                this.lblZoom.setText(Double.toString(zoom * 100.0) + "%");
            }
        } else if (this.lblZoom != null) {
            this.lblZoom.setText("");
        }
    }

    private void SetZoom(double zoom) {
        if (zoom < 0.1 || zoom > 4.0) {
            zoom = 1.0;
        }
        this.box.setZoom(zoom);
        this.AjusteTamanho();
        if (this.lblZoom != null) {
            this.lblZoom.setText(Double.toString(zoom * 100.0) + "%");
        }
    }

    public void ZoomMenos() {
        double z = this.getZoom();
        int p = -1;
        for (int i = 0; i < this.zoonsd.length; ++i) {
            if (this.zoonsd[i] != z) continue;
            p = i - 1;
        }
        if (p < 0) {
            return;
        }
        z = this.zoonsd[p];
        this.setZoom(z);
    }

    public void ZoomMais() {
        double z = this.getZoom();
        int p = this.zoonsd.length;
        for (int i = 0; i < this.zoonsd.length; ++i) {
            if (this.zoonsd[i] != z) continue;
            p = i + 1;
        }
        if (p > this.zoonsd.length - 1) {
            return;
        }
        z = this.zoonsd[p];
        this.setZoom(z);
    }

    public void setLabelZoom(JLabel lblZoom) {
        this.lblZoom = lblZoom;
        lblZoom.setText("100.0%");
    }

    public void setMostrarAreaImpressao(boolean mostrarAreaImpressao, int wdt, int ht) {
        this.box.setMostrarAreaImpressao(mostrarAreaImpressao, wdt, ht);
    }

    public void AtualizeTreeNavegacao() {
        int tl = this.diagramaAtual.AtualizeTreeNavegacao(true).getChildCount();
        if (tl != this.lastTreeCount) {
            this.lastTreeCount = tl;
            this.FramePrincipal.DoComandoExterno(Controler.menuComandos.cmdTreeNavegador);
        }
    }

    public void Mostre(Point co) {
        this.scrolling = true;
        this.parente.getHorizontalScrollBar().setValue(co.x);
        this.parente.getVerticalScrollBar().setValue(co.y);
        this.scrolling = false;
        this.RegistePosicao();
    }

    public void ScrollMove(MouseWheelEvent e) {
        int x = this.parente.getHorizontalScrollBar().getValue();
        int y = this.parente.getVerticalScrollBar().getValue();
        int vpw = this.parente.getViewport().getWidth() - this.getMargem();
        int vph = this.parente.getViewport().getHeight() - this.getMargem();
        int p1 = e.getX() + this.getMargem() - x;
        int p2 = e.getY() + this.getMargem() - y;
        boolean ambos = p2 > vph && p1 > vpw;
        if ((p1 = vpw - p1) < (p2 = vph - p2) || ambos) {
            this.parente.getVerticalScrollBar().setValue(y + 2 * e.getUnitsToScroll());
        }
        if (p2 < p1 || ambos) {
            this.parente.getHorizontalScrollBar().setValue(x + 2 * e.getUnitsToScroll());
        }
        e.consume();
    }

    public boolean IsOpen(File arq) {
        String tmp = arq.getAbsolutePath();
        for (Diagrama d : this.getDiagramas()) {
            if (!d.getArquivo().equals(tmp)) continue;
            this.setSelected(d);
            JOptionPane.showMessageDialog(this.getParent(), fromConfiguracao.getValor("Controler.interface.mensagem.msg01"), fromConfiguracao.getValor("Controler.interface.mensagem.tit_informacao"), 1);
            return true;
        }
        return false;
    }

    public ArrayList<String> getRecentes() {
        return this.recentes;
    }

    public void setRecentes(ArrayList<String> recentes) {
        this.recentes = recentes;
    }

    public void addLastOpened(String arq) {
        this.recentes.remove(arq);
        this.recentes.add(0, arq);
        this.reloadMenuRecentes();
    }

    public JMenu getMenuRecente() {
        return this.MenuRecente;
    }

    public void setMenuRecente(JMenu MenuRecente) {
        this.MenuRecente = MenuRecente;
    }

    public void reloadMenuRecentes() {
        for (int i = 0; i < 10 && this.recentes.size() > i; ++i) {
            String arq = this.recentes.get(i);
            String tmp = arq;
            if (tmp.lastIndexOf(File.separator) > 0) {
                tmp = tmp.substring(tmp.lastIndexOf(File.separator) + 1);
            }
            if (this.MenuRecente.getItemCount() > i + 2) {
                this.MenuRecente.getItem(i).setText(tmp);
                this.MenuRecente.getItem(i).setToolTipText(arq);
                continue;
            }
            JMenuItem jmi = new JMenuItem(tmp);
            jmi.setToolTipText(arq);
            jmi.addActionListener(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    File arq = new File(((JMenuItem)ae.getSource()).getToolTipText());
                    if (arq.exists()) {
                        Editor.this.AbrirDiagramaFromFile(arq);
                    } else {
                        JOptionPane.showMessageDialog(Editor.this.getParent(), "Diagrama n\u00e3o pode ser aberto. Arquivo n\u00e3o encontrado.", "Informa\u00e7\u00e3o", 1);
                    }
                }
            });
            this.MenuRecente.add((Component)jmi, this.MenuRecente.getItemCount() - 2);
        }
        this.MenuRecente.setEnabled(this.MenuRecente.getItemCount() > 2);
    }

    private void ChecarArquivosBiAbertos(Diagrama diag) {
        this.getDiagramas().stream().filter(d -> !d.getArquivo().isEmpty() && d != diag).forEach(d -> {
            if (d.getArquivo().equals(diag.getArquivo())) {
                BrLogger.Logger("ERRO_SAME_FILE", " (" + d.getNome() + ")", null);
            }
        });
    }

    public void InicieNovoInspector(Inspector quem, iParaOutrosInspectors falsoEdt) {
        this.falsoEditor = falsoEdt;
        this.outroInspector = quem;
        this.outroInspector.setEditor(this);
    }

    public Controler getControler() {
        return this.controler;
    }

    public void DoActionExtender(ActionEvent ev) {
        if (this.diagramaAtual != null) {
            if (ev == null || ev.getActionCommand() == null || ev.getActionCommand().isEmpty()) {
                return;
            }
            try {
                Controler.menuComandos cmd = Controler.menuComandos.valueOf(ev.getActionCommand());
                switch (cmd) {
                    case cmdRendo: {
                        if (!this.refazer()) {
                            BrLogger.Logger("ERROR_CMD_RENDO", null);
                        }
                        this.controler.makeEnableComands();
                        break;
                    }
                    case cmdUndo: {
                        if (!this.desfazer()) {
                            BrLogger.Logger("ERROR_CMD_UNDO", null);
                        }
                        this.controler.makeEnableComands();
                        break;
                    }
                    case cmdDel: {
                        this.diagramaAtual.deleteSelecao();
                        this.controler.makeEnableComands();
                        break;
                    }
                    case cmdSelectAllByType: {
                        this.diagramaAtual.SelecioneTodosDoTipo();
                        this.controler.makeEnableComands();
                        break;
                    }
                    case cmdSelectAll: {
                        this.diagramaAtual.SelecioneTodos();
                        this.controler.makeEnableComands();
                        break;
                    }
                    case cmdSelProx: {
                        this.diagramaAtual.SelecioneProximo();
                        break;
                    }
                    case cmdBringToFront: {
                        if (this.diagramaAtual.getSelecionado() != null) {
                            this.diagramaAtual.getSelecionado().BringToFront();
                            this.diagramaAtual.getSelecionado().Invalidate();
                        }
                        break;
                    }
                    case cmdSendToBack: {
                        if (this.diagramaAtual.getSelecionado() != null) {
                            this.diagramaAtual.getSelecionado().SendToBack();
                            this.diagramaAtual.getSelecionado().Invalidate();
                        }
                        break;
                    }
                    case cmdSelAnt: {
                        this.diagramaAtual.SelecioneAnterior();
                        break;
                    }
                    case cmdMicroAjuste0: {
                        this.diagramaAtual.ProcesseTeclas(37);
                        break;
                    }
                    case cmdMicroAjuste1: {
                        this.diagramaAtual.ProcesseTeclas(38);
                        break;
                    }
                    case cmdMicroAjuste2: {
                        this.diagramaAtual.ProcesseTeclas(40);
                        break;
                    }
                    case cmdMicroAjuste3: {
                        this.diagramaAtual.ProcesseTeclas(39);
                        break;
                    }
                    case cmdCopy: {
                        this.diagramaAtual.doCopy();
                        break;
                    }
                    case cmdCopyImg: {
                        int borda = 2;
                        Point p2 = this.diagramaAtual.getPontoExtremoSelecionado();
                        int minX = p2.x;
                        int minY = p2.y;
                        for (int i = this.diagramaAtual.getItensSelecionados().size() - 1; i > -1; --i) {
                            FormaElementar el2 = this.diagramaAtual.getItensSelecionados().get(i);
                            minX = Math.min(minX, el2.getLeft());
                            minY = Math.min(minY, el2.getTop());
                        }
                        minX = Math.max(minX - 2, 0);
                        minY = Math.max(minY - 2, 0);
                        BufferedImage cp_img = ImageGenerate.geraImagemForPrnSelecao(this.diagramaAtual, p2.x + 2, p2.y + 2);
                        BufferedImage cp_img2 = cp_img.getSubimage(minX, minY, p2.x - minX, p2.y - minY);
                        this.diagramaAtual.doCopy(cp_img2);
                        break;
                    }
                    case cmdCopyFormat: {
                        if (this.diagramaAtual.getSelecionado() != null) {
                            this.CopiadorFormatacao.Copiar(this.diagramaAtual.getSelecionado());
                            this.controler.makeEnableComands();
                        }
                        break;
                    }
                    case cmdDimPastLeft: 
                    case cmdDimPastTop: 
                    case cmdDimPastRight: 
                    case cmdDimPastBottom: 
                    case cmdDimPastWidth: 
                    case cmdDimPastHeight: 
                    case cmdDimAlignH: 
                    case cmdDimAlignV: {
                        if (this.diagramaAtual.getSelecionado() != null) {
                            ArrayList<FormaElementar> lst = new ArrayList<FormaElementar>();
                            this.diagramaAtual.getItensSelecionados().stream().forEach(f -> lst.add((FormaElementar)f));
                            this.diagramaAtual.setSelecionado(null);
                            this.CopiadorFormatacao.Ajustar(lst, cmd, this.diagramaAtual.AlinhamentoH(), this.diagramaAtual.AlinhamentoV());
                            this.diagramaAtual.DoMuda(this.diagramaAtual.getSelecionado());
                            lst.stream().forEach(el -> this.diagramaAtual.DiagramaDoSelecao((FormaElementar)el, false, true));
                            this.diagramaAtual.PromoveToFirstSelect(lst.get(0));
                        }
                        break;
                    }
                    case cmdPasteFormat: {
                        if (this.diagramaAtual.getSelecionado() != null) {
                            this.CopiadorFormatacao.Colar(this.diagramaAtual.getItensSelecionados());
                        }
                        break;
                    }
                    case cmdCut: {
                        this.diagramaAtual.doCopy();
                        this.diagramaAtual.deleteSelecao();
                        this.controler.makeEnableComands();
                        break;
                    }
                    case cmdRealcar: {
                        this.diagramaAtual.setRealce(!this.diagramaAtual.isRealce());
                        this.controler.makeEnableComands();
                        break;
                    }
                    case cmdPaste: {
                        this.diagramaAtual.doPaste();
                        this.controler.makeEnableComands();
                        break;
                    }
                    case cmdSave: {
                        this.diagramaAtual.Salvar(this.diagramaAtual.getArquivo());
                        this.RePopuleBarraDiagramas(false);
                        this.controler.makeEnableComands();
                        this.ChecarArquivosBiAbertos(this.diagramaAtual);
                        break;
                    }
                    case cmdSaveAs: {
                        this.diagramaAtual.Salvar();
                        this.RePopuleBarraDiagramas(false);
                        this.controler.makeEnableComands();
                        this.ChecarArquivosBiAbertos(this.diagramaAtual);
                        break;
                    }
                    case cmdSaveAll: {
                        this.getDiagramas().stream().forEach(d -> d.Salvar(d.getArquivo()));
                        this.getDiagramas().stream().forEach(d -> this.ChecarArquivosBiAbertos((Diagrama)d));
                        this.RePopuleBarraDiagramas(false);
                        this.controler.makeEnableComands();
                        break;
                    }
                    case cmdNew: {
                        if (ev.getSource() instanceof JMenuItem) {
                            JMenuItem tmp = (JMenuItem)ev.getSource();
                            this.Add(tmp.getName());
                            this.RePopuleBarraDiagramas(true);
                            break;
                        }
                        if (ev.getSource() instanceof JButton) {
                            JButton tmp = (JButton)ev.getSource();
                            this.Add(tmp.getName());
                            this.RePopuleBarraDiagramas(true);
                        }
                        break;
                    }
                    case cmdOpen: {
                        File arq = Dialogos.ShowDlgLoadDiagrama(this.diagramaAtual.getArquivo(), this);
                        this.AbrirDiagramaFromFile(arq);
                        this.ChecarArquivosBiAbertos(this.diagramaAtual);
                        break;
                    }
                    case cmdPrint: {
                        this.FramePrincipal.DoComandoExterno(cmd);
                        break;
                    }
                    case cmdClose: {
                        Diagrama afechar = this.diagramaAtual;
                        int idx = this.getDiagramas().indexOf(afechar) + 1;
                        int tam = this.getDiagramas().size();
                        if (idx == tam) {
                            idx -= 2;
                        }
                        if (idx > -1) {
                            Diagrama nv = this.getDiagramas().get(idx);
                            if (this.FechaDiagrama(afechar, nv)) {
                                this.diagramaAtual = nv;
                                this.prepareDiagramaAtual();
                            }
                        } else {
                            this.FechaDiagrama(afechar, null);
                        }
                        this.controler.makeEnableComands();
                        this.RePopuleBarraDiagramas(true);
                        break;
                    }
                    case cmdExport: {
                        File arqui = Dialogos.ShowDlgSaveAsImg(this, this.diagramaAtual);
                        if (arqui != null) {
                            Point p = this.diagramaAtual.getPontoExtremo();
                            BufferedImage img = ImageGenerate.geraImagemForPrn(this.diagramaAtual, p.x, p.y);
                            if (Arquivo.IsBMP(arqui)) {
                                ImageIO.write((RenderedImage)img, "bmp".toUpperCase(), arqui);
                                break;
                            }
                            ImageIO.write((RenderedImage)img, "png".toUpperCase(), arqui);
                        }
                        break;
                    }
                    default: {
                        this.getDicas().setTexto(cmd.toString());
                    }
                }
            }
            catch (Exception e) {
                BrLogger.Logger("ERROR_CMD_INVALID", ev.getActionCommand(), e.getMessage());
            }
        }
    }

    private void AbrirDiagramaFromFile(File arq) {
        Diagrama res = Diagrama.LoadFromFile(arq, this);
        if (res != null) {
            this.ProcessePosOpen(res, !Arquivo.IsbrM3(arq));
        }
    }

    private void ProcessePosOpen(Diagrama res, boolean isXml) {
        if (res != null) {
            res.setMaster(this);
            int idx = -1;
            if (!this.diagramaAtual.isAlterado()) {
                idx = this.historicos.getDiagramas().indexOf(this.diagramaAtual);
                this.FechaDiagrama(this.diagramaAtual, res);
            }
            this.validate();
            this.diagramaAtual = res;
            res.setMudou(false);
            if (idx > -1) {
                this.historicos.add(this.diagramaAtual, idx);
            } else {
                this.historicos.add(this.diagramaAtual);
            }
            res.OnAfterLoad(isXml);
            this.prepareDiagramaAtual();
            this.RePopuleBarraDiagramas(true);
        }
    }

    public void DoAction(ActionEvent ev) {
        if (this.diagramaAtual != null) {
            this.diagramaAtual.DoAction(ev);
            boolean eacao = false;
            Acao ac = null;
            if (((AbstractButton)ev.getSource()).getAction() instanceof Acao) {
                eacao = true;
                ac = (Acao)((AbstractButton)ev.getSource()).getAction();
                this.setTextoDica(null, ac.getValue("ShortDescription").toString());
            }
            if (ev.getSource() instanceof JMenuItem && eacao) {
                this.controler.SelecioneForAction(ac);
            }
        }
    }

    public void PerformInspectorFor(FormaElementar itemSel) {
        this.setTextoDica(null, "");
        this.getInspectorEditor().Carrege(itemSel.GenerateFullProperty());
        this.EditoresRefresh(itemSel);
        this.FramePrincipal.DoComandoExterno(Controler.menuComandos.cmdTreeSelect);
    }

    public boolean AceitaEdicao(Inspector origem, InspectorProperty propriedade, String valor) {
        if (origem == this.editorConfig) {
            return this.AceitaEdicao(propriedade, valor);
        }
        if (origem == this.outroInspector) {
            return this.falsoEditor.AceitaEdicao(propriedade, valor);
        }
        if (this.diagramaAtual != null) {
            return this.diagramaAtual.AceitaEdicao(propriedade, valor);
        }
        return false;
    }

    public void PopuleBarra(JComponent tollBar) {
        this.controler.PopuleBarra(tollBar);
        if (this.diagramaAtual != null) {
            this.controler.AjusteBarra(this.diagramaAtual.meusComandos);
        }
    }

    public void RePopuleBarraDiagramas(boolean reset) {
        if (this.showDiagramas != null) {
            if (reset) {
                this.showDiagramas.Reset(this.historicos.getDiagramas().indexOf(this.diagramaAtual));
            } else {
                this.showDiagramas.repaint();
            }
        }
    }

    public void PopuleBarra(JMenu menu) {
        this.controler.PopuleBarra(menu);
    }

    public void PopuleMenus(JMenu MenuEditar, JMenu MenuArquivo, JPopupMenu popup) {
        this.controler.PopuleMenus(MenuEditar, MenuArquivo, popup);
    }

    public void NoAction() {
        this.controler.BtnNothing.setSelected(true);
    }

    public InspectorDicas getDicas() {
        return this.Dicas;
    }

    public void setDicas(InspectorDicas Dicas) {
        this.Dicas = Dicas;
    }

    public Inspector getInspectorEditor() {
        return this.InspectorEditor;
    }

    public void setInspectorEditor(Inspector InspectorEditor) {
        this.InspectorEditor = InspectorEditor;
        InspectorEditor.setEditor(this);
        this.diagramaAtual.PerformInspector();
    }

    public void setTextoDica(Inspector quem, String txt) {
        if (this.Dicas != null) {
            this.Dicas.setTexto(txt);
        }
    }

    public static String getClassTexto(Elementar obj) {
        return obj.getClass().getSimpleName();
    }

    public boolean SelectItemByID(int id) {
        FormaElementar res;
        if (this.diagramaAtual != null && (res = this.diagramaAtual.FindByID(id)) != null) {
            return this.diagramaAtual.DiagramaDoSelecao(res, false, false);
        }
        return false;
    }

    public final void Add(String pa) {
        ArrayList<String> lst = new ArrayList<String>();
        for (Diagrama.TipoDeDiagrama tp : Diagrama.TipoDeDiagrama.values()) {
            lst.add(tp.name());
        }
        int res = lst.indexOf(pa);
        if (res == -1) {
            return;
        }
        this.diagramaAtual = this.Novo(Diagrama.TipoDeDiagrama.values()[res]);
        this.prepareDiagramaAtual();
        this.historicos.add(this.diagramaAtual);
    }

    public final Diagrama Add() {
        this.diagramaAtual = this.Novo(null);
        this.prepareDiagramaAtual();
        this.historicos.add(this.diagramaAtual);
        return this.diagramaAtual;
    }

    public Diagrama AddAsAtual(String strTipo) {
        this.Add(strTipo);
        this.RePopuleBarraDiagramas(true);
        return this.diagramaAtual;
    }

    public Diagrama Novo(Diagrama.TipoDeDiagrama tipo) {
        if (tipo == null) {
            tipo = this.getTipoDefault();
        }
        return Diagrama.Factory(tipo, this);
    }

    public void setParente(JScrollPane parente) {
        this.parente = parente;
        parente.getHorizontalScrollBar().setBlockIncrement(100);
        parente.getVerticalScrollBar().setBlockIncrement(100);
        parente.getHorizontalScrollBar().setUnitIncrement(10);
        parente.getVerticalScrollBar().setUnitIncrement(10);
        parente.getHorizontalScrollBar().addAdjustmentListener(ae -> {
            if (!this.scrolling) {
                this.RegistePosicao();
            }
        });
        parente.getVerticalScrollBar().addAdjustmentListener(ae -> {
            if (!this.scrolling) {
                this.RegistePosicao();
            }
        });
    }

    public void DoDiagramaMuda() {
        this.RegistePosicao();
        this.historicos.append(this.diagramaAtual);
        this.controler.makeEnableComands();
        this.AtualizeTreeNavegacao();
        this.doneAutoSave = false;
    }

    public void RegistePosicao() {
        if (this.parente != null) {
            this.diagramaAtual.ScrPosicao = new Point(this.parente.getHorizontalScrollBar().getValue(), this.parente.getVerticalScrollBar().getValue());
        }
    }

    public void prepareDiagramaAtual() {
        try {
            this.SetZoom(this.diagramaAtual.getZoom());
            if (this.parente != null) {
                this.scrolling = true;
                this.parente.getHorizontalScrollBar().setValue(this.diagramaAtual.ScrPosicao.x);
                this.parente.getVerticalScrollBar().setValue(this.diagramaAtual.ScrPosicao.y);
                this.scrolling = false;
            }
            this.controler.makeEnableComands();
            if (this.getInspectorEditor() != null) {
                this.diagramaAtual.PerformInspector();
                this.controler.AjusteBarra(this.diagramaAtual.meusComandos);
                if (this.showDiagramas != null) {
                    this.showDiagramas.repaint();
                }
                this.repaint();
                this.lastTreeCount = -1;
                this.AtualizeTreeNavegacao();
                this.diagramaAtual.populeComandos(this.controler.BarraMenu.getItem(0));
                this.diagramaAtual.ExternalSuperAncorador();
            }
        }
        catch (Exception e) {
            BrLogger.Logger("ERROR_DIAGRAMA_PREPARE", e.getMessage());
        }
    }

    public boolean desfazer() {
        Diagrama res = this.historicos.desfazer(this.diagramaAtual);
        if (res != null) {
            double z = this.diagramaAtual.getZoom();
            this.diagramaAtual = res;
            this.diagramaAtual.setZoom(z);
            this.prepareDiagramaAtual();
            return true;
        }
        return false;
    }

    public boolean refazer() {
        Diagrama res = this.historicos.refazer(this.diagramaAtual);
        if (res != null) {
            double z = this.diagramaAtual.getZoom();
            this.diagramaAtual = res;
            this.diagramaAtual.setZoom(z);
            this.prepareDiagramaAtual();
            return true;
        }
        return false;
    }

    public boolean podeDesfazer() {
        return this.historicos.podeDesfazer(this.diagramaAtual);
    }

    public boolean podeRefazer() {
        return this.historicos.podeRefazer(this.diagramaAtual);
    }

    public boolean ProcesseCmdFromInspector(Inspector who, String property) {
        FormaElementar.nomeComandos cmd;
        if (who == this.editorConfig) {
            return false;
        }
        if (who == this.outroInspector) {
            return this.falsoEditor.ProcesseCmdFromInspector(property);
        }
        try {
            cmd = FormaElementar.nomeComandos.valueOf(property);
        }
        catch (Exception e2) {
            return false;
        }
        switch (cmd) {
            case cmdLoadImg: {
                if (this.diagramaAtual == null || !(this.diagramaAtual.getSelecionado() instanceof Desenhador)) break;
                String res = Dialogos.ShowDlgFileImg(this.getRootPane());
                if (res == null) {
                    return true;
                }
                this.getFramePrincipal().Super_Esperando();
                if (((Desenhador)this.diagramaAtual.getSelecionado()).LoadImageFromFile(res)) {
                    this.getFramePrincipal().Super_Pronto();
                    this.PerformInspectorFor(this.diagramaAtual.getSelecionado());
                    return true;
                }
                this.getFramePrincipal().Super_Pronto();
                this.PerformInspectorFor(this.diagramaAtual.getSelecionado());
                break;
            }
            case cmdDlgLegenda: {
                if (this.diagramaAtual == null || !(this.diagramaAtual.getSelecionado() instanceof Legenda) || !((Legenda)this.diagramaAtual.getSelecionado()).canShowEditor()) break;
                this.EditorLegendaCarregue(this.diagramaAtual.getSelecionado());
                return true;
            }
            case cmdCallDrawerEditor: {
                if (this.diagramaAtual == null || !(this.diagramaAtual.getSelecionado() instanceof iBaseDrawer)) break;
                this.EditorBaseDrawerCarregue(this.diagramaAtual.getSelecionado());
                return true;
            }
            case cmdExcluirSubItem: {
                if (this.diagramaAtual == null) break;
                this.diagramaAtual.getSelecionado().ExcluirSubItem(who.getSelecionado().getPropriedade().Tag);
                this.PerformInspectorFor(this.diagramaAtual.getSelecionado());
                return true;
            }
            case cmdFonte: {
                if (this.diagramaAtual == null) break;
                FormaElementar fe = this.diagramaAtual.getSelecionado() == null ? this.diagramaAtual.infoDiagrama : this.diagramaAtual.getSelecionado();
                Font f = fe.getFont();
                f = Dialogos.ShowDlgFont(this.getRootPane(), f);
                if (f == null) break;
                if (fe == this.diagramaAtual.infoDiagrama) {
                    fe.setFont(f);
                } else {
                    List lst = this.diagramaAtual.getItensSelecionados().stream().filter(e -> e.getClass().equals(fe.getClass())).collect(Collectors.toList());
                    for (FormaElementar Ed : lst) {
                        Ed.setFont(f);
                    }
                }
                this.diagramaAtual.DoMuda(fe);
                this.PerformInspectorFor(fe);
                return true;
            }
            case cmdAdicionarSubItem: {
                if (this.diagramaAtual == null) break;
                this.diagramaAtual.getSelecionado().AdicionarSubItem(who.getSelecionado().getPropriedade().Tag);
                this.PerformInspectorFor(this.diagramaAtual.getSelecionado());
                return true;
            }
            case cmdDoAnyThing: {
                if (this.diagramaAtual == null) break;
                if (this.diagramaAtual.getSelecionado() == null) {
                    this.diagramaAtual.DoAnyThing(who.getSelecionado().getPropriedade().Tag);
                } else {
                    this.diagramaAtual.getSelecionado().DoAnyThing(who.getSelecionado().getPropriedade().Tag);
                    this.diagramaAtual.PerformInspector(true);
                }
                return true;
            }
        }
        return false;
    }

    public void EditoresRefresh(FormaElementar itemSel) {
        if (this.editorLegenda != null && this.editorLegenda.isVisible()) {
            if (itemSel instanceof Legenda && ((Legenda)itemSel).canShowEditor()) {
                this.EditorLegendaCarregue(itemSel);
            } else {
                this.EditorLegendaCarregue(null);
            }
        }
    }

    private void EditorLegendaCarregue(FormaElementar itemSel) {
        if (this.editorLegenda == null) {
            this.editorLegenda = new LegendaEditor();
            this.editorLegenda.setLocation(200, 200);
        }
        this.editorLegenda.Init((Legenda)itemSel);
        this.editorLegenda.setVisible(true);
    }

    private void EditorBaseDrawerCarregue(FormaElementar selecionado) {
        DrawerEditor de = new DrawerEditor((Frame)Aplicacao.fmPrincipal, true);
        de.setLocationRelativeTo(Aplicacao.fmPrincipal);
        de.Inicie(selecionado);
        de.setVisible(true);
    }

    private boolean FechaDiagrama(Diagrama afechar, Diagrama noLugar) {
        boolean needProcAutoSave = true;
        if (afechar.getMudou()) {
            afechar.ClearSelect(true);
            int res = Dialogos.ShowMessageSave(afechar);
            if (res == 0) {
                if (!afechar.Salvar(afechar.getArquivo())) {
                    return false;
                }
                needProcAutoSave = false;
            } else if (res == 2) {
                return false;
            }
        }
        if (noLugar == null) {
            noLugar = this.Add();
        }
        afechar.IsStopEvents = true;
        this.historicos.removeDiagrama(afechar, noLugar);
        if (needProcAutoSave) {
            this.DoAutoSaveCompleto();
        }
        return true;
    }

    public void FechaDiagrama(int idx) {
        int tam;
        Diagrama afechar = this.getDiagramas().get(idx);
        if (afechar == this.diagramaAtual) {
            ++idx;
        }
        if (idx == (tam = this.getDiagramas().size())) {
            idx -= 2;
        }
        if (idx > -1) {
            Diagrama nv = this.getDiagramas().get(idx);
            if (afechar != this.diagramaAtual) {
                nv = this.diagramaAtual;
            }
            if (this.FechaDiagrama(afechar, nv)) {
                this.diagramaAtual = nv;
                this.prepareDiagramaAtual();
            }
        } else {
            this.FechaDiagrama(afechar, null);
        }
        this.controler.makeEnableComands();
        this.RePopuleBarraDiagramas(true);
    }

    public ArrayList<Diagrama> getDiagramas() {
        return this.historicos.getDiagramas();
    }

    public Mostrador getShowDiagramas() {
        return this.showDiagramas;
    }

    public void setShowDiagramas(Mostrador shDiag) {
        this.showDiagramas = shDiag;
        if (shDiag != null) {
            shDiag.setMaster(this);
        }
    }

    public void AtiveDiagrama(int diagNro) {
        this.diagramaAtual = this.historicos.getDiagramas().get(diagNro);
        this.prepareDiagramaAtual();
    }

    public void setSelected(Diagrama diag) {
        int i = this.getDiagramas().indexOf(diag);
        this.showDiagramas.setSelectedIndex(i);
        this.AtiveDiagrama(i);
    }

    public void NomeieDiagrama(Diagrama diag) {
        if (diag == null) {
            return;
        }
        List txts = this.getDiagramas().stream().map(d -> d.getNome()).collect(Collectors.toList());
        int res = 1;
        String txt = diag.getTipoDeDiagramaFormatado();
        while (txts.indexOf(txt + "_" + res) != -1) {
            ++res;
        }
        diag.setNome(txt + "_" + res);
    }

    public void FecharTudo() {
        this.historicos.removeAll();
        this.diagramaAtual = this.Add();
        this.prepareDiagramaAtual();
        this.controler.makeEnableComands();
        this.RePopuleBarraDiagramas(true);
        this.DoAutoSaveCompleto();
    }

    public int getAutoSaveInterval() {
        return this.autoSaveInterval;
    }

    public void setAutoSaveInterval(int autoSaveInterval) {
        if (autoSaveInterval > -1 && autoSaveInterval < 30) {
            this.autoSaveInterval = autoSaveInterval;
        }
        this.autoSaveAtivo = autoSaveInterval > 0;
        this.InicieAutoSave();
    }

    private boolean InicieAutoSave() {
        if (this.tempoAs != null) {
            this.tempoAs.cancel();
            this.tempoAs = null;
        }
        if (!this.autoSaveAtivo) {
            this.EndAutoSave();
            return false;
        }
        Timer timer = new Timer();
        this.autoSaveIniciado = true;
        this.tempoAs = new Temporizador(this);
        timer.schedule((TimerTask)this.tempoAs, 0L, (long)(this.autoSaveInterval * 1000 * 60));
        return true;
    }

    private boolean PreInicieAutoSave(int iter) {
        this.autoSaveInterval = iter;
        boolean bl = this.autoSaveAtivo = this.autoSaveInterval > 0;
        if (this.autoSaveAtivo) {
            Timer timer = new Timer();
            this.autoSaveIniciado = true;
            this.tempoAs = new Temporizador(this);
            timer.schedule((TimerTask)this.tempoAs, this.autoSaveInterval * 1000 * 60, (long)(this.autoSaveInterval * 1000 * 60));
            return true;
        }
        return false;
    }

    private boolean DoAutoSave() {
        if (this.doneAutoSave) {
            return true;
        }
        this.DoStatus(fromConfiguracao.getValor("Controler.MSG_STATUS_AUTOSAVE"));
        this.doneAutoSave = true;
        this.autoSave.clear();
        this.getDiagramas().stream().filter(d -> d.getMudou()).forEach(d -> d.AutoSalvar(this.autoSave));
        return this.AutoSalveToFile();
    }

    private boolean AutoSalveToFile() {
        boolean bl;
        FileOutputStream fo = new FileOutputStream(fromConfiguracao.getAutoSaveFile());
        ObjectOutputStream out = new ObjectOutputStream(fo);
        try {
            out.writeObject(this.autoSave);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                BrLogger.Logger("ERROR_DIAGRAMA_AUTOSAVE_WIRTE", iOException.getMessage());
                return false;
            }
        }
        out.close();
        return bl;
    }

    public void EndAutoSave() {
        if (this.autoSaveIniciado) {
            this.autoSaveIniciado = false;
            this.autoSave.clear();
            this.AutoSalveToFile();
        }
    }

    public void DoAutoSaveCompleto() {
        if (this.autoSaveIniciado) {
            this.doneAutoSave = false;
            this.DoAutoSave();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean LoadAutoSave() {
        File f = new File(fromConfiguracao.getAutoSaveFile());
        if (!f.exists()) {
            return false;
        }
        try {
            FileInputStream fi = new FileInputStream(f);
            try (ObjectInputStream in = new ObjectInputStream(fi);){
                ArrayList salvado = (ArrayList)in.readObject();
                if (salvado.isEmpty()) return false;
                if (!Dialogos.ShowMessageConfirmYES(this.getRootPane(), fromConfiguracao.getValor(salvado.size() > 1 ? "Controler.MSG_CONFIRM_LOAD_AUTOSAVE_PLURAL" : "Controler.MSG_CONFIRM_LOAD_AUTOSAVE"), false)) {
                    in.close();
                    boolean bl = false;
                    return bl;
                }
                salvado.stream().forEach(k -> {
                    try {
                        ObjectInputStream inb = new ObjectInputStream(new ByteArrayInputStream((byte[])k));
                        GuardaPadraoBrM seguranca = (GuardaPadraoBrM)inb.readObject();
                        inb.close();
                        Diagrama res = Diagrama.LoadFromBrm(seguranca, this);
                        this.ProcessePosOpen(res, false);
                        res.setMudou(true);
                    }
                    catch (IOException | ClassNotFoundException | NullPointerException iOException) {
                        BrLogger.Logger("ERROR_DIAGRAMA_AUTOSAVE_LOAD", "STREAM LENGTH: " + String.valueOf(((byte[])k).length), iOException.getMessage());
                    }
                });
                in.close();
                this.doneAutoSave = false;
                this.controler.makeEnableComands();
                this.AtualizeTreeNavegacao();
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException | ClassNotFoundException | NullPointerException iOException) {
            BrLogger.Logger("ERROR_DIAGRAMA_AUTOSAVE_LOAD", iOException.getMessage());
        }
        return false;
    }

    public JLabel getLblStatus() {
        return this.lblStatus;
    }

    public void setLblStatus(JLabel lblStatus) {
        this.lblStatus = lblStatus;
    }

    public void DoStatus(String msg) {
        if (this.lblStatus == null) {
            return;
        }
        new Timer().schedule((TimerTask)new Temporizador(this, msg), 0L, 1000L);
    }

    public boolean isAncorador() {
        return this.Ancorador;
    }

    public void setAncorador(boolean Ancorador2) {
        if (this.Ancorador == Ancorador2) {
            return;
        }
        this.Ancorador = Ancorador2;
        if (this.diagramaAtual != null) {
            this.diagramaAtual.ExternalSuperAncorador();
        }
    }

    public boolean isMostrarIDs() {
        return this.mostrarIDs;
    }

    public void setMostrarIDs(boolean mostrarIDs) {
        if (this.mostrarIDs == mostrarIDs) {
            return;
        }
        this.mostrarIDs = mostrarIDs;
    }

    public boolean isMostrarTooltips() {
        return this.mostrarTooltips;
    }

    public void setMostrarTooltips(boolean mostrarTooltips) {
        if (this.mostrarTooltips == mostrarTooltips) {
            return;
        }
        this.mostrarTooltips = mostrarTooltips;
    }

    public boolean isApagarTextoAoEditar() {
        return this.apagarTextoAoEditar;
    }

    public void setApagarTextoAoEditar(boolean apagarTextoAoEditar) {
        this.apagarTextoAoEditar = apagarTextoAoEditar;
    }

    class Temporizador
    extends TimerTask {
        private final Editor master;
        private final int tipo;
        private String MSG = "";
        private int tick = 0;
        final int AUTOSAVE = 0;
        final int STATUS = 1;

        public Temporizador(Editor omaster) {
            this.master = omaster;
            this.tipo = 0;
        }

        public Temporizador(Editor omaster, String msg) {
            this.master = omaster;
            this.tipo = 1;
            this.MSG = msg;
        }

        @Override
        public void run() {
            if (this.tipo == 0) {
                this.master.DoAutoSave();
            } else {
                JLabel jl = this.master.getLblStatus();
                if ("".equals(jl.getText())) {
                    jl.setText(this.MSG);
                } else {
                    jl.setText("");
                }
                ++this.tick;
                if (this.tick > 5) {
                    jl.setText("");
                    this.cancel();
                }
            }
        }
    }

    public static interface iParaOutrosInspectors {
        public boolean AceitaEdicao(InspectorProperty var1, String var2);

        public boolean ProcesseCmdFromInspector(String var1);
    }
}

