/*
 * Decompiled with CFR 0.152.
 */
package controlador.editores;

import controlador.apoios.TreeItem;
import desenho.formas.Forma;
import diagramas.logico.Campo;
import diagramas.logico.DiagramaLogico;
import diagramas.logico.Tabela;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class EditorDeTipos
extends JDialog {
    private int resultado = 2;
    int v = 0;
    private int largura = 0;
    ArrayList<String> tipos = new ArrayList();
    private JPanel Principal;
    private JButton btnFechar;
    private JButton btnOK;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    public JLabel lblMsg;
    private JTree tree;
    DiagramaLogico diagrama = null;
    List<Tabela> tabelas = null;
    private transient TreeItem TreeRoot = null;
    private Tabela selecionada = null;

    public EditorDeTipos(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.getRootPane().registerKeyboardAction(e -> {
            this.setResultado(2);
            this.setVisible(false);
        }, KeyStroke.getKeyStroke(27, 0), 2);
    }

    public int getResultado() {
        return this.resultado;
    }

    public void setResultado(int resultado) {
        this.resultado = resultado;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.lblMsg = new JLabel();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.Principal = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.tree = new JTree();
        this.jPanel2 = new JPanel();
        this.btnFechar = new JButton();
        this.btnOK = new JButton();
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("principal/Formularios_pt_BR");
        this.setTitle(bundle.getString("EditorDeTipos.title"));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(bundle.getString("EditorDeTipos.tituloTabela")));
        this.lblMsg.setText(bundle.getString("EditorDeTipos.info"));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(25, 25, 25).addComponent(this.lblMsg).addContainerGap(346, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblMsg, GroupLayout.Alignment.TRAILING, -1, 24, Short.MAX_VALUE));
        this.jSplitPane1.setDividerLocation(220);
        this.Principal.setBackground(new Color(204, 204, 204));
        this.Principal.setLayout(null);
        this.jScrollPane1.setViewportView(this.Principal);
        this.jSplitPane1.setRightComponent(this.jScrollPane1);
        this.jScrollPane2.setViewportView(this.tree);
        this.jSplitPane1.setLeftComponent(this.jScrollPane2);
        this.jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.btnFechar.setText(bundle.getString("EditorDeCampos.Fechar"));
        this.btnFechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditorDeTipos.this.btnFecharActionPerformed(evt);
            }
        });
        this.btnOK.setText(bundle.getString("EditorDeTipos.btnContinuar"));
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditorDeTipos.this.btnOKActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.btnFechar).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnOK, -2, 107, -2)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addGap(0, 0, 0).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnFechar).addComponent(this.btnOK))));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jSplitPane1));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addGap(1, 1, 1).addComponent(this.jSplitPane1, -1, 372, Short.MAX_VALUE).addGap(1, 1, 1).addComponent(this.jPanel2, -2, -1, -2)));
        this.pack();
    }

    private void btnFecharActionPerformed(ActionEvent evt) {
        this.setResultado(2);
        this.setVisible(false);
    }

    private void btnOKActionPerformed(ActionEvent evt) {
        this.setResultado(0);
        this.setVisible(false);
    }

    public void AdicionarPainel(final Campo cmp) {
        JPanel ItemPan = new JPanel();
        int altura = 37;
        ItemPan.setSize(this.largura, 37);
        FlowLayout lay = new FlowLayout(0, 10, 5);
        ItemPan.setLayout(lay);
        ResourceBundle bundle = ResourceBundle.getBundle("principal/Formularios_pt_BR");
        JTextField txtNome = new JTextField();
        txtNome.setEditable(false);
        JLabel lblNome = new JLabel();
        final JComboBox<Object> comboTipo = new JComboBox<Object>();
        JLabel lblTipo = new JLabel();
        lblNome.setText(bundle.getString("EditorDeCampos.lblCampo"));
        lblNome.setSize(new Dimension(37, 14));
        ItemPan.add(lblNome);
        txtNome.setToolTipText("");
        txtNome.setPreferredSize(new Dimension(190, 20));
        ItemPan.add(txtNome);
        lblTipo.setText(bundle.getString("EditorDeCampos.lblTipo"));
        lblTipo.setSize(new Dimension(24, 14));
        ItemPan.add(lblTipo);
        comboTipo.setEditable(true);
        String tipo_txt = cmp.getTipo();
        if (!tipo_txt.trim().isEmpty() && this.tipos.indexOf(tipo_txt) < 0) {
            this.tipos.add(tipo_txt);
        }
        comboTipo.setModel(new DefaultComboBoxModel<Object>(this.tipos.toArray()));
        comboTipo.setPreferredSize(new Dimension(73, 20));
        ItemPan.add(comboTipo);
        this.Principal.add(ItemPan);
        if (this.largura == 0) {
            this.largura = lay.preferredLayoutSize((Container)ItemPan).width;
        }
        ItemPan.setBounds(0, this.v, this.largura, 37);
        this.v += 40;
        this.Principal.setPreferredSize(new Dimension(this.largura, this.v));
        txtNome.setText(cmp.getTexto());
        comboTipo.setSelectedItem(tipo_txt);
        comboTipo.addActionListener(e -> {
            String txt = comboTipo.getSelectedItem().toString();
            if (!txt.equals(cmp.getTipo())) {
                cmp.setTipo(txt);
                cmp.getTabela().DoMuda();
                cmp.InvalidateArea();
                this.tipoAlterado();
                if (this.tipos.indexOf(txt) < 0) {
                    this.tipos.add(0, txt);
                }
            }
        });
        comboTipo.getEditor().addActionListener(e -> {
            String txt = comboTipo.getSelectedItem().toString();
            if (!txt.equals(cmp.getTipo())) {
                cmp.setTipo(txt);
                cmp.getTabela().DoMuda();
                cmp.InvalidateArea();
                this.tipoAlterado();
                if (this.tipos.indexOf(txt) < 0) {
                    this.tipos.add(0, txt);
                }
            }
        });
        comboTipo.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
                comboTipo.setSelectedItem(cmp.getTipo());
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
                comboTipo.setSelectedItem(cmp.getTipo());
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                comboTipo.setModel(new DefaultComboBoxModel<Object>(EditorDeTipos.this.tipos.toArray()));
            }
        });
        ItemPan.validate();
        this.Principal.validate();
    }

    public void Inicie(DiagramaLogico diag) {
        this.diagrama = diag;
        this.tabelas = this.diagrama.getListaDeTabelas();
        for (int i = 0; i < this.tabelas.size(); ++i) {
            Tabela t = this.tabelas.get(i);
            t.getCampos().forEach(c -> {
                String tp = c.getTipo();
                if (!tp.isEmpty() && this.tipos.indexOf(tp) < 0) {
                    this.tipos.add(tp);
                }
            });
        }
        this.tipos.addAll(diag.getDataModel().getDataTypes());
        this.tree.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean isLeaf, int row, boolean focused) {
                Component c = super.getTreeCellRendererComponent(tree, value, selected, expanded, isLeaf, row, focused);
                if (value instanceof TreeItem) {
                    int id = ((TreeItem)value).getId();
                    if (id == 0) {
                        this.setIcon(EditorDeTipos.this.diagrama.getEditor().getControler().ImagemDeDiagrama.get(EditorDeTipos.this.diagrama.getTipo().name()));
                    } else {
                        ImageIcon img = EditorDeTipos.this.diagrama.getEditor().getControler().getImagem(((TreeItem)value).getExtraInfo());
                        if (img != null) {
                            this.setIcon(img);
                        }
                    }
                }
                return c;
            }
        });
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                EditorDeTipos.this.treeValueChanged(null);
            }
        });
        this.tree.addTreeSelectionListener(evt -> this.treeValueChanged(evt));
        this.AtualizeTreeNavegacao();
        this.setSelecionada(null);
    }

    private void treeValueChanged(TreeSelectionEvent evt) {
        if (this.tree.getLastSelectedPathComponent() != null) {
            int v = ((TreeItem)this.tree.getLastSelectedPathComponent()).getId();
            if (v > 0) {
                this.setSelecionada((Tabela)this.diagrama.FindByID(v));
            } else {
                this.setSelecionada(null);
            }
        }
    }

    public void AtualizeTreeNavegacao() {
        this.tree.getSelectionModel().setSelectionMode(1);
        this.TreeRoot = new TreeItem(this.diagrama.getNomeFormatado());
        this.diagrama.getListaDeItens().stream().filter(it -> it instanceof Tabela).map(it -> (Tabela)it).forEach(it -> {
            String tp = it.getCampos().stream().filter(c -> c.getTipo().isEmpty()).anyMatch(c -> c.getTipo().isEmpty()) ? "error" : "ok";
            this.TreeRoot.add(new TreeItem(it.getTexto(), it.getID(), tp));
        });
        this.tree.setModel(new DefaultTreeModel(this.TreeRoot));
    }

    public Tabela getSelecionada() {
        return this.selecionada;
    }

    public void setSelecionada(Tabela selecionada) {
        if (this.selecionada != selecionada) {
            this.selecionada = selecionada;
            this.Popule(selecionada);
        }
    }

    private void Popule(Tabela sel) {
        this.Principal.removeAll();
        this.Principal.validate();
        this.v = 0;
        if (sel != null) {
            sel.getCampos().stream().forEach(c -> this.AdicionarPainel((Campo)c));
        }
        this.Principal.repaint();
    }

    private void tipoAlterado() {
        if (this.getSelecionada() == null) {
            return;
        }
        TreeItem root = this.TreeRoot;
        for (int i = 0; i < root.getChildCount(); ++i) {
            TreeItem item = (TreeItem)root.getChildAt(i);
            Tabela tbl = (Tabela)this.diagrama.FindByID(item.getId());
            String tp = tbl.getCampos().stream().filter(c -> c.getTipo().isEmpty()).anyMatch(c -> c.getTipo().isEmpty()) ? "error" : "ok";
            item.setExtraInfo(tp);
        }
        this.tree.repaint();
    }

    public void SelecioneByDiagramaSelecionado() {
        DefaultTreeModel df = (DefaultTreeModel)this.tree.getModel();
        if (df.getRoot() instanceof TreeItem) {
            TreeItem root = (TreeItem)df.getRoot();
            TreePath pt = new TreePath(root);
            if (this.diagrama.getSelecionado() == null || !(this.diagrama.getSelecionado() instanceof Forma)) {
                return;
            }
            for (int i = 0; i < root.getChildCount(); ++i) {
                TreeItem item = (TreeItem)root.getChildAt(i);
                if (item.getId() != this.diagrama.getSelecionado().getID()) continue;
                this.tree.setSelectionPath(pt.pathByAddingChild(item));
                break;
            }
        }
        this.btnOK.setText("OK");
        this.btnFechar.setVisible(false);
    }
}

