/*
 * Decompiled with CFR 0.152.
 */
package controlador.editores;

import controlador.Editor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import util.BrLogger;
import util.Dialogos;
import util.TextLineNumber;

public class EditorTexto
extends JDialog
implements ClipboardOwner {
    int tamFonte = 12;
    private JButton btnCopy;
    private JButton btnFechar;
    private JButton btnSalvar;
    private JButton btnZma;
    private JButton btnZmn;
    private JPanel jPanel2;
    private JToolBar.Separator jSeparator1;
    private JToolBar jToolBar1;
    private JScrollPane scrPrincipal;
    private JTextField txtZoon;
    public JTextArea TextArea = null;

    public EditorTexto(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.TextArea = new JTextArea();
        TextLineNumber tln = new TextLineNumber(this.TextArea);
        tln.setUpdateFont(true);
        this.scrPrincipal.getViewport().add(this.TextArea);
        this.scrPrincipal.setRowHeaderView(tln);
        this.pack();
        this.getRootPane().registerKeyboardAction(e -> this.setVisible(false), KeyStroke.getKeyStroke(27, 0), 2);
        this.getRootPane().registerKeyboardAction(e -> this.setVisible(false), KeyStroke.getKeyStroke(10, 128), 2);
        this.getRootPane().registerKeyboardAction(e -> this.btnCopyActionPerformed(null), KeyStroke.getKeyStroke(67, 128), 2);
        this.setTitle(Editor.fromConfiguracao.getValor("Controler.interface.Titulo.EditorDeCodigo"));
        this.pack();
    }

    private void initComponents() {
        this.scrPrincipal = new JScrollPane();
        this.jToolBar1 = new JToolBar();
        this.btnZmn = new JButton();
        this.txtZoon = new JTextField();
        this.btnZma = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.btnCopy = new JButton();
        this.btnSalvar = new JButton();
        this.jPanel2 = new JPanel();
        this.btnFechar = new JButton();
        this.setDefaultCloseOperation(2);
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.jToolBar1.setMargin(new Insets(2, 2, 2, 2));
        this.btnZmn.setIcon(new ImageIcon(this.getClass().getResource("/imagens/zoommenos.png")));
        this.btnZmn.setFocusable(false);
        this.btnZmn.setHorizontalTextPosition(0);
        this.btnZmn.setVerticalTextPosition(3);
        this.btnZmn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditorTexto.this.btnZmnActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnZmn);
        this.txtZoon.setEditable(false);
        this.txtZoon.setHorizontalAlignment(0);
        this.txtZoon.setText("12");
        ResourceBundle bundle = ResourceBundle.getBundle("principal/Formularios_pt_BR");
        this.txtZoon.setToolTipText(bundle.getString("MostradorDeCodigo.toolTipText"));
        this.jToolBar1.add(this.txtZoon);
        this.btnZma.setIcon(new ImageIcon(this.getClass().getResource("/imagens/zoom.png")));
        this.btnZma.setFocusable(false);
        this.btnZma.setHideActionText(true);
        this.btnZma.setHorizontalTextPosition(0);
        this.btnZma.setVerticalTextPosition(3);
        this.btnZma.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditorTexto.this.btnZmaActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnZma);
        this.jToolBar1.add(this.jSeparator1);
        this.btnCopy.setIcon(new ImageIcon(this.getClass().getResource("/imagens/copy.png")));
        this.btnCopy.setFocusable(false);
        this.btnCopy.setHorizontalTextPosition(0);
        this.btnCopy.setPressedIcon(new ImageIcon(this.getClass().getResource("/imagens/cpdim_cp.png")));
        this.btnCopy.setVerticalTextPosition(3);
        this.btnCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditorTexto.this.btnCopyActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnCopy);
        this.btnSalvar.setIcon(new ImageIcon(this.getClass().getResource("/imagens/menu_salvarc.png")));
        this.btnSalvar.setFocusable(false);
        this.btnSalvar.setHorizontalTextPosition(0);
        this.btnSalvar.setVerticalTextPosition(3);
        this.btnSalvar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditorTexto.this.btnSalvarActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnSalvar);
        this.btnFechar.setText(bundle.getString("MC.btnFchar"));
        this.btnFechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditorTexto.this.btnFecharActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.btnFechar)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.btnFechar)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrPrincipal, -1, 640, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jToolBar1, -2, 131, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jToolBar1, -2, -1, -2).addGap(1, 1, 1).addComponent(this.scrPrincipal, -1, 397, Short.MAX_VALUE).addGap(1, 1, 1).addComponent(this.jPanel2, -2, -1, -2)));
        this.pack();
    }

    private void btnCopyActionPerformed(ActionEvent evt) {
        StringSelection vai = new StringSelection(this.TextArea.getText());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(vai, this);
    }

    private void btnFecharActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void btnZmnActionPerformed(ActionEvent evt) {
        --this.tamFonte;
        this.reFont();
    }

    private void btnZmaActionPerformed(ActionEvent evt) {
        ++this.tamFonte;
        this.reFont();
    }

    private void btnSalvarActionPerformed(ActionEvent evt) {
        File arq = Dialogos.ShowDlgSaveAsAny(this.getRootPane(), "");
        if (arq == null) {
            return;
        }
        if (arq.exists() && Dialogos.ShowMessageConfirm(this.getRootPane(), Editor.fromConfiguracao.getValor("Controler.MSG_QUESTION_REWRITE")) != 0) {
            return;
        }
        try {
            FileWriter fw = new FileWriter(arq.getAbsoluteFile(), true);
            this.TextArea.write(fw);
        }
        catch (IOException iOException) {
            BrLogger.Logger("ERROR_DIAGRAMA_SAVE_ANY", iOException.getMessage());
        }
    }

    public JTextArea getTextArea() {
        return this.TextArea;
    }

    public String getTexto() {
        return this.TextArea.getText();
    }

    public void setTexto(String texto) {
        this.TextArea.setText(texto);
    }

    private void reFont() {
        if (this.tamFonte > 72) {
            this.tamFonte = 72;
        }
        if (this.tamFonte < 1) {
            this.tamFonte = 1;
        }
        Font f = this.TextArea.getFont();
        this.TextArea.setFont(new Font(f.getFamily(), f.getStyle(), this.tamFonte));
        this.txtZoon.setText(String.valueOf(this.tamFonte));
    }

    @Override
    public void lostOwnership(Clipboard clpbrd, Transferable t) {
    }
}

