/*
 * Decompiled with CFR 0.152.
 */
package controlador.editores;

import desenho.formas.Legenda;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class JListItemParaItemLegenda
extends JLabel
implements ListCellRenderer {
    final Color HIGHLIGHT_COLOR = new Color(0, 0, 128);
    private final boolean ehLina;

    public JListItemParaItemLegenda(boolean ehLinha) {
        this.setOpaque(true);
        this.setIconTextGap(6);
        this.ehLina = ehLinha;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Legenda.ItemDeLegenda entry = (Legenda.ItemDeLegenda)value;
        this.setText(entry.getTexto());
        BufferedImage off_Image = new BufferedImage(this.ehLina ? 32 : 16, 16, 2);
        Graphics2D g = off_Image.createGraphics();
        RenderingHints renderHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        renderHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.addRenderingHints(renderHints);
        g.setColor(entry.getCor());
        if (this.ehLina) {
            g.fillRect(1, 6, 30, 4);
        } else {
            g.fillRect(1, 1, 14, 14);
        }
        ImageIcon img = new ImageIcon(off_Image);
        this.setIcon(img);
        if (isSelected) {
            this.setBackground(this.HIGHLIGHT_COLOR);
            this.setForeground(Color.white);
        } else {
            this.setBackground(Color.white);
            this.setForeground(Color.black);
        }
        return this;
    }
}

