/*
 * Decompiled with CFR 0.152.
 */
package desenho.formas;

import controlador.Diagrama;
import desenho.formas.Forma;
import desenho.linhas.PontoDeLinha;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import util.Utilidades;

public class FormaNaoRetangularBase
extends Forma {
    private static final long serialVersionUID = 8190306678762122439L;
    protected Shape Regiao = null;
    protected TipoDePontos Tipo = TipoDePontos.tp4Pontos;
    protected Direcao direcao = Direcao.Up;

    public FormaNaoRetangularBase(Diagrama modelo) {
        super(modelo);
    }

    public FormaNaoRetangularBase(Diagrama modelo, String texto) {
        super(modelo, texto);
    }

    @Override
    public boolean IntersectPath(Rectangle recsel) {
        return this.getRegiao().intersects(recsel);
    }

    @Override
    public void DoPaint(Graphics2D g) {
        this.PinteRegiao(g);
        super.DoPaint(g);
    }

    protected void PinteRegiao(Graphics2D g) {
        g.setPaint(this.getForeColor());
        g.draw(this.getRegiao());
    }

    @Override
    public boolean IsMe(Point p) {
        if (super.IsMe(p)) {
            return this.getRegiao().contains(p);
        }
        return false;
    }

    public Shape getRegiao() {
        if (this.Regiao == null) {
            this.Regiao = this.getArea();
        }
        return this.Regiao;
    }

    public void setRegiao(Shape regiao) {
        this.Regiao = regiao;
    }

    @Override
    public void ReSized() {
        this.DestruaRegiao();
        super.ReSized();
    }

    protected void DestruaRegiao() {
        this.setRegiao(null);
    }

    protected TipoDePontos getTipo() {
        return this.Tipo;
    }

    protected void setTipo(TipoDePontos tipo) {
        if (this.Tipo != tipo) {
            this.Tipo = tipo;
            this.setRegiao(null);
            this.SendNotificacao(5);
        }
    }

    protected Direcao getDirecao() {
        return this.direcao;
    }

    protected final void setDirecao(Direcao direcao) {
        if (this.direcao != direcao) {
            this.direcao = direcao;
            this.setRegiao(null);
            this.SendNotificacao(5);
        }
    }

    protected void setDirecaoNaoNotifique(Direcao direcao) {
        if (this.direcao != direcao) {
            this.direcao = direcao;
            this.setRegiao(null);
        }
    }

    @Override
    public void PosicionePonto(PontoDeLinha ponto) {
        switch (this.Tipo) {
            case tp2Pontos: {
                this.Posicione2Pontos(ponto);
                break;
            }
            case tp3Pontos: {
                this.Posicione3Pontos(ponto);
                break;
            }
            case tp4Pontos: {
                this.Posicione4Pontos(ponto);
            }
        }
    }

    protected void Posicione2Pontos(PontoDeLinha ponto) {
        this.calculePontos();
        Point centro = ponto.getCentro();
        switch (this.direcao) {
            case Up: 
            case Down: 
            case Vertical: {
                double dp3 = this.distance(centro, this.pontoPosi6);
                double dp1 = this.distance(centro, this.pontoPosi4);
                if (dp1 < dp3) {
                    ponto.setCentro(this.pontoPosi4);
                    ponto.setLado(1);
                    break;
                }
                ponto.setCentro(this.pontoPosi6);
                ponto.setLado(3);
                break;
            }
            case Left: 
            case Right: 
            case Horizontal: {
                double dp0 = this.distance(centro, this.pontoPosi7);
                double dp2 = this.distance(centro, this.pontoPosi5);
                if (dp0 < dp2) {
                    ponto.setCentro(this.pontoPosi7);
                    ponto.setLado(0);
                    break;
                }
                ponto.setCentro(this.pontoPosi5);
                ponto.setLado(2);
            }
        }
    }

    protected void Posicione4Pontos(PontoDeLinha ponto) {
        Point centro = ponto.getCentro();
        Point[] ll = this.getPontosColaterais();
        int mx = this.retorneProximidade(centro, ll);
        ponto.setCentro(ll[mx]);
        ponto.setLado(mx);
    }

    protected void Posicione3Pontos(PontoDeLinha ponto) {
        this.calculePontos();
        Rectangle r = new Rectangle(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight());
        Point p0 = r.getLocation();
        Point p1 = new Point(r.x + r.width, r.y);
        Point p2 = new Point(r.x + r.width, r.y + r.height);
        Point p3 = new Point(r.x, r.y + r.height);
        Point centro = ponto.getCentro();
        switch (this.direcao) {
            case Up: {
                Point pt1 = this.pontoPosi4;
                Point pt2 = p2;
                Point pt3 = p3;
                Point pMeio = this.pontoPosi6;
                Point[] pts = new Point[]{pt1, pt2, pt3, pMeio};
                int idx = this.retorneProximidade(centro, pts);
                Point res = pts[idx];
                if (res.equals(pt1)) {
                    ponto.setCentro(pt1);
                    ponto.setLado(1);
                    break;
                }
                if (res.equals(pMeio)) {
                    ponto.setCentro(this.pontoPosi6);
                    ponto.setLado(3);
                    break;
                }
                if (res.equals(pt2)) {
                    ponto.setCentro(pt2);
                    ponto.setLado(2);
                    break;
                }
                if (!res.equals(pt3)) break;
                ponto.setCentro(pt3);
                ponto.setLado(0);
                break;
            }
            case Right: {
                Point pt1 = this.pontoPosi5;
                Point pt2 = p3;
                Point pt3 = p0;
                Point pMeio = this.pontoPosi7;
                Point[] pts = new Point[]{pt1, pt2, pt3, pMeio};
                int idx = this.retorneProximidade(centro, pts);
                Point res = pts[idx];
                if (res.equals(pt1)) {
                    ponto.setCentro(pt1);
                    ponto.setLado(2);
                    break;
                }
                if (res.equals(pMeio)) {
                    ponto.setCentro(this.pontoPosi7);
                    ponto.setLado(0);
                    break;
                }
                if (res.equals(pt2)) {
                    ponto.setCentro(pt2);
                    ponto.setLado(3);
                    break;
                }
                if (!res.equals(pt3)) break;
                ponto.setCentro(pt3);
                ponto.setLado(1);
                break;
            }
            case Down: {
                Point pt1 = this.pontoPosi6;
                Point pt2 = p0;
                Point pt3 = p1;
                Point pMeio = this.pontoPosi4;
                Point[] pts = new Point[]{pt1, pt2, pt3, pMeio};
                int idx = this.retorneProximidade(centro, pts);
                Point res = pts[idx];
                if (res.equals(pt1)) {
                    ponto.setCentro(pt1);
                    ponto.setLado(3);
                    break;
                }
                if (res.equals(pMeio)) {
                    ponto.setCentro(this.pontoPosi4);
                    ponto.setLado(1);
                    break;
                }
                if (res.equals(pt2)) {
                    ponto.setCentro(pt2);
                    ponto.setLado(0);
                    break;
                }
                if (!res.equals(pt3)) break;
                ponto.setCentro(pt3);
                ponto.setLado(2);
                break;
            }
            case Left: {
                Point pt1 = this.pontoPosi7;
                Point pt2 = p1;
                Point pt3 = p2;
                Point pMeio = this.pontoPosi5;
                Point[] pts = new Point[]{pt1, pt2, pt3, pMeio};
                int idx = this.retorneProximidade(centro, pts);
                Point res = pts[idx];
                if (res.equals(pt1)) {
                    ponto.setCentro(pt1);
                    ponto.setLado(0);
                    break;
                }
                if (res.equals(pMeio)) {
                    ponto.setCentro(this.pontoPosi5);
                    ponto.setLado(2);
                    break;
                }
                if (res.equals(pt2)) {
                    ponto.setCentro(pt2);
                    ponto.setLado(1);
                    break;
                }
                if (!res.equals(pt3)) break;
                ponto.setCentro(pt3);
                ponto.setLado(3);
            }
        }
    }

    @Override
    public int retorneProximidade(Point centro) {
        return this.retorneProximidade(centro, this.getPontosColaterais());
    }

    protected int retorneProximidade(Point centro, Point[] osPts) {
        double[] dp = new double[osPts.length];
        for (int i = 0; i < osPts.length; ++i) {
            dp[i] = this.distance(centro, osPts[i]);
        }
        int mx = 0;
        for (int i = 1; i < osPts.length; ++i) {
            if (!(dp[mx] > dp[i])) continue;
            mx = i;
        }
        return mx;
    }

    public final double distance(Point p, Point q) {
        return Utilidades.distance(p, q);
    }

    @Override
    protected void PropagueResizeParaLigacoes() {
        this.SendNotificacao(5);
    }

    @Override
    protected void DoPaintDoks(Graphics2D g) {
        Point[] pts = this.getPontosColaterais();
        Paint bkpP = g.getPaint();
        g.setPaint(Color.yellow);
        for (int i = 0; i < pts.length; ++i) {
            g.fillRect(pts[i].x - 2, pts[i].y - 2, 4, 4);
        }
        g.setPaint(bkpP);
    }

    public static enum Direcao {
        Up,
        Right,
        Down,
        Left,
        Horizontal,
        Vertical;

    }

    public static enum TipoDePontos {
        tp4Pontos,
        tp3Pontos,
        tp2Pontos;

    }
}

