/*
 * Decompiled with CFR 0.152.
 */
package desenho.formas;

import controlador.Diagrama;
import desenho.formas.Forma;
import desenho.linhas.PontoDeLinha;
import java.awt.Graphics2D;
import util.DesenhadorDeTexto;

public class FormaTextoBase
extends Forma {
    private static final long serialVersionUID = 5374766439117842226L;
    private AlinhamentoTexto Alinhamento = AlinhamentoTexto.alCentro;
    private boolean centrarVertical = false;
    private boolean simplesDezenho = true;

    public FormaTextoBase(Diagrama modelo) {
        super(modelo);
    }

    public FormaTextoBase(Diagrama modelo, String texto) {
        super(modelo, texto);
    }

    public boolean isCentrarVertical() {
        return this.centrarVertical;
    }

    public void setCentrarVertical(boolean centrar) {
        if (centrar != this.centrarVertical) {
            this.centrarVertical = centrar;
            DesenhadorDeTexto edt = this.getTextoFormatado();
            edt.setCentrarTextoVertical(centrar);
            this.InvalidateArea();
        }
    }

    public AlinhamentoTexto getAlinhamento() {
        return this.Alinhamento;
    }

    public void setAlinhamentoByInt(int Alinhamento) {
        try {
            this.setAlinhamento(AlinhamentoTexto.values()[Alinhamento]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setAlinhamento(AlinhamentoTexto Alinhamento) {
        if (this.Alinhamento != Alinhamento) {
            this.Alinhamento = Alinhamento;
            DesenhadorDeTexto edt = this.getTextoFormatado();
            switch (Alinhamento) {
                case alCentro: {
                    edt.setCentrarTextoHorizontal(true);
                    break;
                }
                case alDireita: {
                    edt.setAlinharDireita(true);
                    break;
                }
                case alEsquerda: {
                    edt.setAlinharEsquerda(true);
                }
            }
            this.InvalidateArea();
        }
    }

    public void ReSetAlinhamento(DesenhadorDeTexto edt) {
        if (edt == null || this.Alinhamento == null) {
            return;
        }
        switch (this.Alinhamento) {
            case alCentro: {
                edt.setCentrarTextoHorizontal(true);
                break;
            }
            case alDireita: {
                edt.setAlinharDireita(true);
                break;
            }
            case alEsquerda: {
                edt.setAlinharEsquerda(true);
            }
        }
        edt.LimitarAreaDePintura = true;
        edt.setCentrarTextoVertical(this.isCentrarVertical());
    }

    @Override
    public void DoPaint(Graphics2D g) {
        g.setPaint(this.getForeColor());
        super.DoPaint(g);
    }

    public boolean isSimplesDezenho() {
        return this.simplesDezenho;
    }

    public void setSimplesDezenho(boolean simplesDezenho) {
        this.simplesDezenho = simplesDezenho;
    }

    @Override
    protected void DoPaintDoks(Graphics2D g) {
        if (!this.simplesDezenho) {
            super.DoPaintDoks(g);
        }
    }

    @Override
    public boolean CanLiga(PontoDeLinha aThis) {
        if (!this.simplesDezenho) {
            return super.CanLiga(aThis);
        }
        return false;
    }

    @Override
    public DesenhadorDeTexto getTextoFormatado() {
        DesenhadorDeTexto edt = super.getTextoFormatado();
        this.ReSetAlinhamento(edt);
        return edt;
    }

    public static enum AlinhamentoTexto {
        alCentro,
        alEsquerda,
        alDireita;

    }
}

