/*
 * Decompiled with CFR 0.152.
 */
package desenho.formas;

import controlador.Diagrama;
import desenho.formas.FormaNaoRetangularBase;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;

public class FormaTriangular
extends FormaNaoRetangularBase {
    private static final long serialVersionUID = -582124975126214085L;
    private Point[] PontosDoTriangulo = null;
    protected String toPaintTxt = "";
    private transient double z = 0.0;

    public FormaTriangular(Diagrama modelo) {
        super(modelo);
        this.setTipo(FormaNaoRetangularBase.TipoDePontos.tp3Pontos);
        this.setDirecao(FormaNaoRetangularBase.Direcao.Up);
    }

    public FormaTriangular(Diagrama modelo, String texto) {
        super(modelo, texto);
        this.setTipo(FormaNaoRetangularBase.TipoDePontos.tp3Pontos);
        this.setDirecao(FormaNaoRetangularBase.Direcao.Up);
    }

    public FormaNaoRetangularBase.Direcao getDirecaoTriangulo() {
        return this.getDirecao();
    }

    public void setDirecaoTriangulo(FormaNaoRetangularBase.Direcao direcaoTriangulo) {
        if (direcaoTriangulo.ordinal() > 3) {
            direcaoTriangulo = FormaNaoRetangularBase.Direcao.Up;
        }
        this.setDirecao(direcaoTriangulo);
        this.DestruaRegiao();
        this.InvalidateArea();
    }

    @Override
    public Shape getRegiao() {
        if (this.Regiao == null) {
            Point[] tri = this.getPontosDoTriangulo();
            Point p1 = tri[0];
            Point p2 = tri[1];
            Point p3 = tri[2];
            Polygon triang = new Polygon();
            triang.addPoint(p1.x, p1.y);
            triang.addPoint(p2.x, p2.y);
            triang.addPoint(p3.x, p3.y);
            this.Regiao = triang;
        }
        return this.Regiao;
    }

    protected Point[] getPontosDoTriangulo() {
        Point pMeio;
        Point pt3;
        Point pt2;
        Point pt1;
        if (this.PontosDoTriangulo != null) {
            return this.PontosDoTriangulo;
        }
        this.calculePontos();
        Rectangle r = new Rectangle(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight());
        Point p0 = r.getLocation();
        Point p1 = new Point(r.x + r.width, r.y);
        Point p2 = new Point(r.x + r.width, r.y + r.height);
        Point p3 = new Point(r.x, r.y + r.height);
        switch (this.direcao) {
            case Up: {
                pt1 = this.pontoPosi4;
                pt2 = p2;
                pt3 = p3;
                pMeio = this.pontoPosi6;
                break;
            }
            case Right: {
                pt1 = this.pontoPosi5;
                pt2 = p3;
                pt3 = p0;
                pMeio = this.pontoPosi7;
                break;
            }
            case Down: {
                pt1 = this.pontoPosi6;
                pt2 = p0;
                pt3 = p1;
                pMeio = this.pontoPosi4;
                break;
            }
            default: {
                pt1 = this.pontoPosi7;
                pt2 = p1;
                pt3 = p2;
                pMeio = this.pontoPosi5;
            }
        }
        this.PontosDoTriangulo = new Point[]{pt1, pt2, pt3, pMeio};
        return this.PontosDoTriangulo;
    }

    @Override
    protected void DestruaRegiao() {
        this.PontosDoTriangulo = null;
        super.DestruaRegiao();
    }

    @Override
    protected void ProcessaDblClick(MouseEvent e) {
        super.ProcessaDblClick(e);
        this.Girar();
    }

    public void Girar() {
        this.setDirecaoTriangulo(FormaNaoRetangularBase.Direcao.values()[this.getDirecaoTriangulo().ordinal() + 1]);
        this.reSetBounds();
        if (this.isSelecionado()) {
            this.getMaster().PerformInspector();
        }
    }

    @Override
    public int retorneProximidade(Point centro) {
        return this.retorneProximidade(centro, this.getPontosDoTriangulo());
    }

    @Override
    public Point getMelhorPontoDeLigacao(Point estePonto) {
        int tmp = this.retorneProximidade(estePonto);
        Point[] ptsLi = this.getPontosDoTriangulo();
        Point res = null;
        int a = 0;
        int b = 0;
        switch (this.direcao) {
            case Up: {
                a = 2;
                break;
            }
            case Right: {
                b = 2;
            }
            case Down: {
                a = -2;
                break;
            }
            default: {
                b = -2;
            }
        }
        switch (tmp) {
            case 0: {
                res = new Point(ptsLi[0].x - b, ptsLi[0].y + a);
                break;
            }
            case 1: {
                res = new Point(ptsLi[1].x - a - b, ptsLi[1].y - b - a);
                break;
            }
            case 2: {
                res = new Point(ptsLi[2].x + a - b, ptsLi[2].y + b - a);
                break;
            }
            case 3: {
                res = new Point(ptsLi[3].x + b, ptsLi[3].y - a);
            }
        }
        return res;
    }

    @Override
    protected void DoPaintDoks(Graphics2D g) {
        Point[] pts = this.getPontosDoTriangulo();
        Paint bkpP = g.getPaint();
        g.setPaint(Color.orange);
        for (Point pt : pts) {
            g.fillRect(pt.x - 2, pt.y - 2, 4, 4);
        }
        g.setPaint(bkpP);
    }

    @Override
    public void PinteTexto(Graphics2D g) {
        if (this.getMaster().getZoom() != this.z) {
            this.setTextoFormatado(null);
            this.z = this.getMaster().getZoom();
        }
        this.getTextoFormatado().PinteTexto(g, this.getForeColor(), this.getArea(), this.toPaintTxt);
    }
}

