/*
 * Decompiled with CFR 0.152.
 */
package desenho.preAnyDiagrama;

import controlador.Diagrama;
import desenho.formas.Forma;
import desenho.formas.FormaNaoRetangularBase;
import desenho.linhas.Linha;
import desenho.linhas.PontoDeLinha;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.util.ArrayList;
import util.DesenhadorDeTexto;

public class PreAtributo
extends FormaNaoRetangularBase {
    private static final long serialVersionUID = 7136642795302925356L;
    private boolean autosize = true;
    private boolean identificador = false;
    private boolean opcional = false;
    private transient double z = 0.0;

    public PreAtributo(Diagrama modelo) {
        super(modelo);
        this.setTipo(FormaNaoRetangularBase.TipoDePontos.tp2Pontos);
        this.setDirecao(FormaNaoRetangularBase.Direcao.Left);
        this.AceitaAjusteAutmatico = false;
    }

    public PreAtributo(Diagrama modelo, String texto) {
        super(modelo, texto);
        this.setTipo(FormaNaoRetangularBase.TipoDePontos.tp2Pontos);
        this.setDirecao(FormaNaoRetangularBase.Direcao.Left);
        this.AceitaAjusteAutmatico = false;
    }

    public FormaNaoRetangularBase.Direcao getDirecaoLigacao() {
        return this.getDirecao();
    }

    public void setDirecaoLigacao(FormaNaoRetangularBase.Direcao DirecaoLigacao) {
        if (DirecaoLigacao != FormaNaoRetangularBase.Direcao.Left && DirecaoLigacao != FormaNaoRetangularBase.Direcao.Right) {
            DirecaoLigacao = FormaNaoRetangularBase.Direcao.Left;
        }
        if (DirecaoLigacao != this.getDirecao()) {
            this.needRecalPts = true;
            this.calculePontos();
            ArrayList<PontoDeLinha> pts = this.getListaDePontosLigados();
            pts.stream().forEach(p -> {
                if (p.getLado() == 0) {
                    p.setCentro(this.pontoPosi5);
                    p.setLado(2);
                } else {
                    p.setCentro(this.pontoPosi7);
                    p.setLado(0);
                }
            });
            this.setDirecao(DirecaoLigacao);
        }
    }

    public boolean isAtributoComposto() {
        ArrayList<PontoDeLinha> lst = this.getListaDePontosLigados();
        int tmp = lst.size();
        if (tmp > 2) {
            return true;
        }
        if (tmp == 0) {
            return false;
        }
        PontoDeLinha pt = this.PontoLigacaoPrincipal(lst);
        return pt == null && tmp > 0 || pt != null && tmp > 1;
    }

    public PontoDeLinha PontoLigacaoPrincipal(ArrayList<PontoDeLinha> pts) {
        if (pts == null) {
            pts = this.getListaDePontosLigados();
        }
        int lado = this.getDirecaoLigacao() == FormaNaoRetangularBase.Direcao.Left ? 0 : 2;
        for (PontoDeLinha p : pts) {
            if (p.getLado() != lado) continue;
            return p;
        }
        return null;
    }

    @Override
    protected void Posicione2Pontos(PontoDeLinha ponto) {
        this.calculePontos();
        if (this.getMaster().isCarregando) {
            super.Posicione2Pontos(ponto);
            return;
        }
        ArrayList<PontoDeLinha> pts = this.getListaDePontosLigados();
        PontoDeLinha pt = this.PontoLigacaoPrincipal(pts);
        boolean pontaPrin = false;
        Forma op = ponto.getDono().getOutraPonta(this);
        if (pt == null) {
            PreAtributo att;
            PontoDeLinha qualPt;
            if (op == null) {
                super.Posicione2Pontos(ponto);
                return;
            }
            pontaPrin = op instanceof PreAtributo ? (qualPt = (att = (PreAtributo)op).PontoLigacaoPrincipal(null)) == null || qualPt.getDono() != ponto.getDono() : true;
        } else if (pt == ponto) {
            if (op == null) {
                super.Posicione2Pontos(ponto);
                return;
            }
            pontaPrin = true;
        } else {
            pontaPrin = false;
        }
        if (!pontaPrin) {
            if (this.getDirecaoLigacao() == FormaNaoRetangularBase.Direcao.Left) {
                ponto.setLado(2);
                ponto.setCentro(this.pontoPosi5);
            } else {
                ponto.setLado(0);
                ponto.setCentro(this.pontoPosi7);
            }
        } else if (this.getDirecaoLigacao() == FormaNaoRetangularBase.Direcao.Left) {
            ponto.setLado(0);
            ponto.setCentro(this.pontoPosi7);
        } else {
            ponto.setLado(2);
            ponto.setCentro(this.pontoPosi5);
        }
    }

    @Override
    protected void ProcessaDblClick(MouseEvent e) {
        super.ProcessaDblClick(e);
        if (this.getDirecaoLigacao() == FormaNaoRetangularBase.Direcao.Left) {
            this.setDirecaoLigacao(FormaNaoRetangularBase.Direcao.Right);
        } else {
            this.setDirecaoLigacao(FormaNaoRetangularBase.Direcao.Left);
        }
        if (this.isSelecionado()) {
            this.getMaster().PerformInspector();
        }
        this.DoMuda();
    }

    public boolean isOpcional() {
        return this.opcional;
    }

    public void setOpcional(boolean opcional) {
        if (this.opcional != opcional) {
            this.opcional = opcional;
            PontoDeLinha qp = this.PontoLigacaoPrincipal(null);
            if (opcional) {
                this.identificador = false;
                if (qp != null) {
                    qp.getDono().setDashed(true);
                }
            } else if (qp != null) {
                qp.getDono().setDashed(false);
            }
            this.InvalidateArea();
        }
    }

    public boolean isIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(boolean identificador) {
        if (this.identificador != identificador) {
            this.identificador = identificador;
            if (identificador && this.opcional) {
                this.setOpcional(false);
            }
            this.InvalidateArea();
        }
    }

    public boolean isAutosize() {
        return this.autosize;
    }

    public void setAutosize(boolean autosize) {
        if (this.autosize == autosize) {
            return;
        }
        this.autosize = autosize;
        this.InvalidateArea();
    }

    @Override
    public void DoPaint(Graphics2D g) {
        if (this.isAutosize()) {
            int largura = g.getFontMetrics(this.getFont()).stringWidth(this.getTextoToDraw()) + this.getHeight() + 4 + 4;
            if (this.getWidth() != largura) {
                this.setStopRaize(true);
                this.setWidth(largura);
                this.setStopRaize(false);
                this.needRecalPts = true;
                this.calculePontos();
                this.SendNotificacao(4);
                this.setRegiao(null);
                if (this.isSelecionado()) {
                    this.Reposicione();
                }
                this.ReSizedByAutoSize();
            }
        }
        super.DoPaint(g);
        Ellipse2D.Float reg = this.getDirecaoLigacao() == FormaNaoRetangularBase.Direcao.Left ? new Ellipse2D.Float(this.getLeft(), this.getTop(), this.getHeight() - 1, this.getHeight() - 1) : new Ellipse2D.Float(this.getLeft() + this.getWidth() - this.getHeight(), this.getTop(), this.getHeight() - 1, this.getHeight() - 1);
        Stroke bkps = g.getStroke();
        if (this.isOpcional()) {
            g.setStroke(new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{4.0f, 2.0f}, 0.0f));
        }
        if (this.isIdentificador()) {
            g.fill(reg);
        } else {
            g.draw(reg);
        }
        if (this.isOpcional()) {
            g.setStroke(bkps);
        }
    }

    @Override
    protected void PinteRegiao(Graphics2D g) {
    }

    @Override
    public void PinteTexto(Graphics2D g) {
        if (this.getMaster().getZoom() != this.z) {
            this.setTextoFormatado(null);
            this.z = this.getMaster().getZoom();
        }
        DesenhadorDeTexto txtf = this.getTextoFormatado();
        Rectangle rec = new Rectangle(this.getDirecaoLigacao() != FormaNaoRetangularBase.Direcao.Left ? this.getLeft() : this.getLeft() + this.getHeight() + 2, this.getTop() - 2, this.getWidth() - this.getHeight() - 2, this.getHeight() + 2);
        txtf.LimitarAreaDePintura = true;
        if (this.getDirecaoLigacao() != FormaNaoRetangularBase.Direcao.Left) {
            txtf.setAlinharDireita(true);
        } else {
            txtf.setAlinharEsquerda(true);
        }
        txtf.PinteTexto(g, this.getForeColor(), rec, this.getTextoToDraw());
        if (this.isAtributoComposto()) {
            this.drawArrow(g, rec.x, rec.y, rec.width, rec.height);
        }
    }

    private void drawArrow(Graphics2D g, int x1, int y1, int x2, int y2) {
        int ARR_SIZE = 3;
        int p = y1 + y2 / 2 + 1;
        if (this.getDirecaoLigacao() != FormaNaoRetangularBase.Direcao.Left) {
            int q = x1;
            g.fillPolygon(new int[]{q, q + ARR_SIZE, q + ARR_SIZE, q}, new int[]{p, p - ARR_SIZE, p + ARR_SIZE, p}, 4);
        } else {
            int q = x1 + x2;
            g.fillPolygon(new int[]{q, q - ARR_SIZE, q - ARR_SIZE, q}, new int[]{p, p - ARR_SIZE, p + ARR_SIZE, p}, 4);
        }
    }

    @Override
    public void ReciveFormaResize(Rectangle ret) {
        if (!this.isAutosize()) {
            super.ReciveFormaResize(ret);
        } else {
            Rectangle rec = new Rectangle(ret.x, ret.y, 0, ret.height);
            super.ReciveFormaResize(rec);
        }
    }

    @Override
    protected void calculePontos() {
        if (!this.needRecalPts) {
            return;
        }
        super.calculePontos();
        this.pontoPosi4 = this.getDirecaoLigacao() == FormaNaoRetangularBase.Direcao.Left ? (this.pontoPosi6 = this.pontoPosi5) : (this.pontoPosi6 = this.pontoPosi7);
    }

    @Override
    protected void DoPaintDoks(Graphics2D g) {
        this.calculePontos();
        Point[] pts = new Point[]{this.pontoPosi7, this.pontoPosi5};
        Paint bkpP = g.getPaint();
        g.setPaint(Color.orange);
        for (int i = 0; i < pts.length; ++i) {
            g.fillRect(pts[i].x - 2, pts[i].y - 2, 4, 4);
        }
        g.setPaint(bkpP);
    }

    @Override
    public int retorneProximidade(Point centro) {
        this.calculePontos();
        double dp0 = this.distance(centro, this.pontoPosi7);
        double dp2 = this.distance(centro, this.pontoPosi5);
        if (dp0 < dp2) {
            return 0;
        }
        return 2;
    }

    @Override
    public boolean CanLiga(Forma forma, Linha lin) {
        if (forma == null) {
            return true;
        }
        if (super.CanLiga(forma, lin)) {
            PontoDeLinha qp = this.PontoLigacaoPrincipal(null);
            if (forma instanceof PreAtributo) {
                PreAtributo pre = (PreAtributo)forma;
                PontoDeLinha qplig = pre.PontoLigacaoPrincipal(null);
                if (qp == null || qplig == null) {
                    return true;
                }
                if (qplig.getDono() == lin) {
                    return true;
                }
            } else {
                if ((lin.getFormaPontaA() == this || lin.getFormaPontaB() == this) && qp == null) {
                    return false;
                }
                return qp == null || qp.getDono() == lin;
            }
        }
        return false;
    }

    protected void ReSizedByAutoSize() {
    }

    public String getTextoToDraw() {
        return super.getTexto();
    }
}

