/*
 * Decompiled with CFR 0.152.
 */
package desenho.preAnyDiagrama;

import controlador.Diagrama;
import controlador.Editor;
import controlador.inspector.InspectorProperty;
import desenho.Elementar;
import desenho.FormaElementar;
import desenho.formas.Forma;
import desenho.linhas.PontoDeLinha;
import desenho.linhas.SuperLinha;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import util.XMLGenerate;

public class PreLigacaoSeta
extends SuperLinha {
    private static final long serialVersionUID = -8546091399978837981L;

    public PreLigacaoSeta(Diagrama diagrama) {
        super(diagrama);
        this.setInteligente(true);
        this.showConfigSeta = true;
        this.setSetaLargura(20);
    }

    @Override
    public boolean Destroy() {
        ArrayList<PontoDeLinha> pontos = this.getPontos();
        pontos.stream().forEach(pdl -> pdl.Destroy());
        return super.Destroy();
    }

    @Override
    public void Inicie(Rectangle r) {
        super.Inicie(0, new Point(r.x, r.y), new Point(r.x + r.width, r.y + r.height));
        this.setTemSetaPontaB(true);
        this.AnexePontos();
        this.OrganizeLinha();
        this.reSetBounds();
    }

    public void SuperSetInteligente(boolean sn) {
        this.SetInteligente(sn);
        this.OrganizeLinha();
    }

    @Override
    public ArrayList<InspectorProperty> CompleteGenerateProperty(ArrayList<InspectorProperty> GP) {
        GP.add(InspectorProperty.PropertyFactorySN("linha.auto", "SuperSetInteligente", this.isInteligente()));
        GP.add(InspectorProperty.PropertyFactoryCor("forecolor", "setForeColor", this.getForeColor()));
        GP = super.CompleteGenerateProperty(GP);
        if (this.getPontaA().getEm() != null || this.getPontaB().getEm() != null) {
            InspectorProperty ipp;
            Forma f;
            GP.add(InspectorProperty.PropertyFactorySeparador("ligacoes"));
            if (this.getPontaA().getEm() != null) {
                f = this.getPontaA().getEm();
                ipp = InspectorProperty.PropertyFactoryActionSelect(Editor.fromConfiguracao.getValor("diagrama." + Editor.getClassTexto(f) + ".nome"), f.getTexto(), String.valueOf(f.getID()));
                GP.add(ipp);
            }
            if (this.getPontaB().getEm() != null) {
                f = this.getPontaB().getEm();
                ipp = InspectorProperty.PropertyFactoryActionSelect(Editor.fromConfiguracao.getValor("diagrama." + Editor.getClassTexto(f) + ".nome"), f.getTexto(), String.valueOf(f.getID()));
                GP.add(ipp);
            }
        }
        return GP;
    }

    @Override
    protected void ToXmlValores(Document doc, Element me) {
        super.ToXmlValores(doc, me);
        NodeList nl = me.getElementsByTagName("Bounds");
        me.removeChild(nl.item(0));
        me.appendChild(XMLGenerate.ValorBoolean(doc, "Inteligente", this.isInteligente()));
        if (!this.getForeColor().equals(Elementar.defaultColor)) {
            me.appendChild(XMLGenerate.ValorColor(doc, "ForeColor", this.getForeColor()));
        }
        me.appendChild(XMLGenerate.ValorInteger(doc, "Largura", (int)this.getLargura()));
        Element lig = doc.createElement("Ligacoes");
        XMLGenerate.AtributoRefFormElementar(lig, "PontaA", this.getFormaPontaA());
        XMLGenerate.AtributoRefFormElementar(lig, "PontaB", this.getFormaPontaB());
        me.appendChild(lig);
        Element sbPontos = doc.createElement("Pontos");
        for (PontoDeLinha pl : this.getPontos()) {
            sbPontos.appendChild(XMLGenerate.ValorPoint(doc, "Ponto", pl.getLocation()));
        }
        me.appendChild(sbPontos);
    }

    @Override
    public boolean CommitXML(Element me, HashMap<Element, FormaElementar> mapa) {
        FormaElementar resB;
        Element lig = XMLGenerate.FindByNodeName(me, "Ligacoes");
        String idPt = lig.getAttribute("PontaA");
        FormaElementar resA = XMLGenerate.FindWhoHasID(idPt, mapa);
        if (resA instanceof Forma) {
            this.getPontaA().SetEm((Forma)resA);
        }
        if ((resB = XMLGenerate.FindWhoHasID(idPt = lig.getAttribute("PontaB"), mapa)) instanceof Forma) {
            this.getPontaB().SetEm((Forma)resB);
        }
        if (resA instanceof Forma) {
            ((Forma)resA).PosicionePonto(this.getPontaA());
        }
        if (resB instanceof Forma) {
            ((Forma)resB).PosicionePonto(this.getPontaB());
        }
        this.OrganizeLinha();
        return super.CommitXML(me, mapa);
    }

    @Override
    public boolean LoadFromXML(Element me, boolean colando) {
        int l;
        if (!super.LoadFromXML(me, colando)) {
            return false;
        }
        this.setInteligente(XMLGenerate.getValorBooleanFrom(me, "Inteligente"));
        Color c = XMLGenerate.getValorColorFrom(me, "ForeColor");
        if (c != null) {
            this.setForeColor(c);
        }
        if ((l = XMLGenerate.getValorIntegerFrom(me, "Largura")) != -1) {
            this.setLargura(l);
        }
        NodeList ptLst = me.getElementsByTagName("Pontos");
        Element pontos = (Element)ptLst.item(0);
        ptLst = pontos.getChildNodes();
        this.Inicie(ptLst.getLength() - 2, new Point(20, 20), new Point(40, 40));
        ArrayList<PontoDeLinha> arrpontos = this.getPontos();
        for (int i = 0; i < ptLst.getLength(); ++i) {
            Point p = XMLGenerate.getValorPoint((Element)ptLst.item(i));
            arrpontos.get(i).setLocation(p);
        }
        return true;
    }
}

