/*
 * Decompiled with CFR 0.152.
 */
package desenho.preDiagrama;

import controlador.Diagrama;
import controlador.inspector.InspectorProperty;
import desenho.FormaElementar;
import desenho.preDiagrama.baseDrawerFromForma;
import desenho.preDiagrama.baseDrawerItem;
import desenho.preDiagrama.iBaseDrawer;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.RoundRectangle2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import util.DesenhadorDeTexto;
import util.XMLGenerate;

public class baseDrawer
extends baseDrawerFromForma
implements iBaseDrawer {
    private static final long serialVersionUID = -5417641185054502949L;
    private boolean mostrarTextoRegua = true;
    private int margem = 24;
    private final int largTraco = 4;
    private Color corRegua = new Color(0, 204, 204);
    private String unidadeMedida = "";
    private int proporcaoQtdPixel = 1;
    private int proporcaoMedida = 1;
    private boolean metricaLeft = true;
    private boolean metricaTop = true;
    private boolean metricaDown = true;
    private boolean metricaRigth = true;
    private ArrayList<baseDrawerItem> Itens = new ArrayList();

    public baseDrawer(Diagrama diagrama, String texto) {
        super(diagrama, texto);
        this.Inicie();
    }

    public baseDrawer(Diagrama diagrama) {
        super(diagrama);
        this.Inicie();
    }

    public boolean isMostrarTextoRegua() {
        return this.mostrarTextoRegua;
    }

    public void setMostrarTextoRegua(boolean mostrarTextoRegua) {
        if (this.mostrarTextoRegua == mostrarTextoRegua) {
            return;
        }
        this.mostrarTextoRegua = mostrarTextoRegua;
        this.InvalidateArea();
    }

    @Override
    protected void DimensioneParaPintura() {
        super.DimensioneParaPintura();
        this.W -= this.margem * 2;
        this.H -= this.margem * 2;
        this.L += this.margem;
        this.T += this.margem;
    }

    @Override
    public void DoPaint(Graphics2D g) {
        g.setPaint(this.getForeColor());
        Paint ori = g.getPaint();
        Composite com = g.getComposite();
        super.DoPaint(g);
        Paint gra = g.getPaint();
        Composite gcom = g.getComposite();
        g.setComposite(com);
        if (this.isMetricaTop()) {
            this.bordaTopDown(g, true);
        }
        if (this.isMetricaDown()) {
            this.bordaTopDown(g, false);
        }
        if (this.isMetricaRigth()) {
            this.bordaLeftRigth(g, true);
        }
        if (this.isMetricaLeft()) {
            this.bordaLeftRigth(g, false);
        }
        g.setComposite(gcom);
        g.setPaint(gra);
        Shape bkpA = g.getClip();
        if (this.roundrect > 0) {
            if (this.isPintarBorda()) {
                RoundRectangle2D.Float sh = new RoundRectangle2D.Float(this.L, this.T, this.W, this.H, this.roundrect, this.roundrect);
                g.setClip(sh);
            }
        } else {
            g.setClip(this.L, this.T, this.W, this.H);
        }
        this.getItens().stream().forEach(bi -> {
            if (!bi.isRecivePaint()) {
                g.setComposite(com);
                g.setPaint(ori);
            } else {
                g.setComposite(gcom);
                g.setPaint(gra);
            }
            bi.setDisablePainted(this.isDisablePainted());
            bi.DoPaint(g);
        });
        g.setClip(bkpA);
        g.setComposite(com);
        g.setPaint(ori);
    }

    public String convertMedidas(int valor) {
        double res = (double)(valor * this.getProporcaoMedida()) / (double)this.getProporcaoQtdPixel();
        return new DecimalFormat(this.getProporcaoMedida() != this.getProporcaoQtdPixel() ? "0.00" : "0.##").format(res);
    }

    protected double getMedidaConvertida(int valor) {
        return (double)(valor * this.getProporcaoMedida()) / (double)this.getProporcaoQtdPixel();
    }

    public Color getCorRegua() {
        return this.corRegua;
    }

    public void setCorRegua(Color corTraco) {
        this.corRegua = corTraco;
        this.InvalidateArea();
    }

    private int calculeSubEspaco(int vl) {
        double pro;
        int bs = 32;
        for (pro = (double)this.getProporcaoQtdPixel() / (double)this.getProporcaoMedida(); pro < 32.0; pro *= 2.0) {
        }
        return (int)Math.round(pro);
    }

    private int modInteiro(int vl) {
        if (vl % 5 == 0) {
            return 5;
        }
        if (vl % 4 == 0) {
            return 4;
        }
        if (vl % 3 == 0) {
            return 3;
        }
        if (vl % 2 == 0) {
            return 2;
        }
        return 0;
    }

    public void bordaTopDown(Graphics2D g, boolean isTop) {
        FontMetrics fm = g.getFontMetrics();
        String vl = this.FormateUnidadeMedida(this.W);
        int xini = this.getLeft() + this.margem;
        int pre_y = isTop ? this.getTop() : this.getTopHeight();
        int xfim = this.getLeftWidth() - this.margem;
        int yfim = pre_y + (isTop ? 2 : -2);
        int traco = 4 < this.margem ? 4 : this.margem;
        traco = isTop ? traco : -traco;
        int ytraco = yfim;
        g.setColor(this.getCorRegua());
        g.drawLine(xini, ytraco, xini, ytraco + 2 * traco);
        g.drawLine(xfim, ytraco, xfim, ytraco + 2 * traco);
        g.drawLine(xini, yfim, xfim, yfim);
        int blc = this.calculeSubEspaco(this.W);
        int sr = xini;
        int dv = this.modInteiro(blc);
        int subblc = 0;
        if (dv > 0) {
            subblc = blc / dv;
        }
        while (sr < xfim) {
            if (dv > 0) {
                for (int a = subblc; a < blc; a += subblc) {
                    if (sr + a >= xfim) continue;
                    g.drawLine(sr + a, ytraco, sr + a, ytraco + traco / 2);
                }
            }
            if ((sr += blc) >= xfim) continue;
            g.drawLine(sr, ytraco, sr, ytraco + traco);
        }
        if (this.isMostrarTextoRegua()) {
            g.setColor(this.getForeColor());
            yfim = pre_y + (isTop ? this.margem / 2 : -this.margem / 2);
            int yini = yfim + fm.getHeight() / 2 - fm.getDescent();
            g.drawString(vl, xini += (this.W - fm.stringWidth(vl)) / 2, yini);
        }
    }

    public void bordaLeftRigth(Graphics2D g, boolean isrigth) {
        FontMetrics fm = g.getFontMetrics();
        String vl = this.FormateUnidadeMedida(this.H);
        int pre_x = isrigth ? this.getLeftWidth() : this.getLeft();
        int traco = 4 < this.margem ? 4 : this.margem;
        traco = isrigth ? -traco : traco;
        int xIni = pre_x + (isrigth ? -2 : 2);
        int xFim = xIni + 2 * traco;
        int yIni = this.getTop() + this.margem;
        int yFim = this.getTopHeight() - this.margem;
        int xLin = xIni;
        g.setColor(this.getCorRegua());
        g.drawLine(xIni, yIni, xFim, yIni);
        g.drawLine(xIni, yFim, xFim, yFim);
        g.drawLine(xLin, yIni, xLin, yFim);
        int blc = this.calculeSubEspaco(this.W);
        int sr = yIni;
        xFim -= traco;
        int dv = this.modInteiro(blc);
        int subblc = 0;
        if (dv > 0) {
            subblc = blc / dv;
        }
        while (sr < yFim) {
            if (dv > 0) {
                for (int a = blc - subblc; a > 0; a -= subblc) {
                    if (sr + a >= yFim) continue;
                    g.drawLine(xIni, sr + a, xFim - traco / 2, sr + a);
                }
            }
            g.drawLine(xIni, sr, xFim, sr);
            sr += blc;
        }
        if (this.isMostrarTextoRegua()) {
            int degrees = isrigth ? 90 : -90;
            int desse = isrigth ? 0 : fm.stringWidth(vl);
            int centra = fm.getHeight() / 2 - fm.getDescent();
            centra = isrigth ? -centra : centra;
            AffineTransform at = AffineTransform.getRotateInstance(Math.toRadians(degrees));
            Font f = new Font(this.getFont().getName(), 1, this.getFont().getSize());
            g.setFont(f.deriveFont(at));
            g.setColor(this.getForeColor());
            xLin = pre_x - (isrigth ? this.margem / 2 : -this.margem / 2);
            yIni = yIni + (this.H - fm.stringWidth(vl)) / 2 + desse;
            g.drawString(vl, xLin + centra, yIni);
            g.setFont(this.getFont());
        }
    }

    private void Inicie() {
        this.setDelimite(false);
        this.SetTexto("");
        this.setAlteraForma(true);
    }

    @Override
    public void SetTexto(String Texto2) {
        super.SetTexto(Texto2);
    }

    @Override
    public DesenhadorDeTexto getTextoFormatado() {
        DesenhadorDeTexto dz = super.getTextoFormatado();
        dz.CorretorPosicao = new Point(0, 6 + this.margem);
        return dz;
    }

    @Override
    public ArrayList<InspectorProperty> GenerateProperty() {
        ArrayList<InspectorProperty> res = super.GenerateProperty();
        res.add(InspectorProperty.PropertyFactorySeparador("basedrawer.titulo.unidademedida"));
        res.add(InspectorProperty.PropertyFactoryTexto("basedrawer.unidademedida", "setUnidadeMedida", this.getUnidadeMedida()));
        res.add(InspectorProperty.PropertyFactoryNumero("basedrawer.proporcaoqtdpixel", "setProporcaoQtdPixel", this.getProporcaoQtdPixel()));
        res.add(InspectorProperty.PropertyFactoryNumero("basedrawer.proporcaomedida", "setProporcaoMedida", this.getProporcaoMedida()));
        res.add(InspectorProperty.PropertyFactorySN("basedrawer.metricaleft", "setMetricaLeft", this.isMetricaLeft()));
        res.add(InspectorProperty.PropertyFactorySN("basedrawer.metricatop", "setMetricaTop", this.isMetricaTop()));
        res.add(InspectorProperty.PropertyFactorySN("basedrawer.metricadown", "setMetricaDown", this.isMetricaDown()));
        res.add(InspectorProperty.PropertyFactorySN("basedrawer.metricarigth", "setMetricaRigth", this.isMetricaRigth()));
        res.add(InspectorProperty.PropertyFactoryTexto("basedrawer.widthunidmedida", "setWidthUnidMedida", this.getWidthUnidMedida()));
        res.add(InspectorProperty.PropertyFactoryTexto("basedrawer.heightunidmedida", "setHeightUnidMedida", this.getHeightUnidMedida()));
        res.add(InspectorProperty.PropertyFactoryCor("basedrawer.corregua", "setCorRegua", this.getCorRegua()));
        res.add(InspectorProperty.PropertyFactoryNumero("basedrawer.margem", "setMargem", this.getMargem()));
        res.add(InspectorProperty.PropertyFactorySN("basedrawer.mostrartextoregua", "setMostrarTextoRegua", this.isMostrarTextoRegua()).PropertyForceDisable(!this.isMetricaLeft() && !this.isMetricaDown() && !this.isMetricaRigth() && !this.isMetricaTop()));
        res.add(InspectorProperty.PropertyFactorySeparador("basedrawer.editor"));
        res.add(InspectorProperty.PropertyFactoryCommand(FormaElementar.nomeComandos.cmdCallDrawerEditor.name()));
        res.add(InspectorProperty.PropertyFactorySeparador("diagrama.formato"));
        res.add(InspectorProperty.PropertyFactorySN("basedrawer.pintarborda", "setPintarBorda", this.isPintarBorda()).AddCondicaoForTrue(new String[]{"setCorBorda", "setRoundrect"}));
        res.add(InspectorProperty.PropertyFactoryCor("basedrawer.corborda", "setCorBorda", this.getCorBorda()));
        return res;
    }

    @Override
    protected void ToXmlValores(Document doc, Element me) {
        super.ToXmlValores(doc, me);
        me.appendChild(XMLGenerate.ValorString(doc, "UnidadeMedida", this.getUnidadeMedida()));
        me.appendChild(XMLGenerate.ValorInteger(doc, "ProporcaoQtdPixel", this.getProporcaoQtdPixel()));
        me.appendChild(XMLGenerate.ValorInteger(doc, "ProporcaoMedida", this.getProporcaoMedida()));
        me.appendChild(XMLGenerate.ValorBoolean(doc, "MetricaLeft", this.isMetricaLeft()));
        me.appendChild(XMLGenerate.ValorBoolean(doc, "MetricaTop", this.isMetricaTop()));
        me.appendChild(XMLGenerate.ValorBoolean(doc, "MetricaDown", this.isMetricaDown()));
        me.appendChild(XMLGenerate.ValorBoolean(doc, "MetricaRigth", this.isMetricaRigth()));
        me.appendChild(XMLGenerate.ValorInteger(doc, "Margem", this.getMargem()));
        me.appendChild(XMLGenerate.ValorColor(doc, "CorRegua", this.getCorRegua()));
        me.appendChild(XMLGenerate.ValorColor(doc, "CorBorda", this.getCorBorda()));
        me.appendChild(XMLGenerate.ValorBoolean(doc, "PintarBorda", this.isPintarBorda()));
        me.appendChild(XMLGenerate.ValorBoolean(doc, "MostrarTextoRegua", this.isMostrarTextoRegua()));
        Element e = XMLGenerate.ValorInteger(doc, "DrawerItens", this.getItens().size());
        this.getItens().stream().forEach(bi -> bi.ToXml(doc, e));
        me.appendChild(e);
    }

    @Override
    public boolean LoadFromXML(Element me, boolean colando) {
        if (!super.LoadFromXML(me, colando)) {
            return false;
        }
        this.setUnidadeMedida(XMLGenerate.getValorStringFrom(me, "UnidadeMedida"));
        this.setProporcaoQtdPixel(XMLGenerate.getValorIntegerFrom(me, "ProporcaoQtdPixel"));
        this.setProporcaoMedida(XMLGenerate.getValorIntegerFrom(me, "ProporcaoMedida"));
        this.setMetricaLeft(XMLGenerate.getValorBooleanFrom(me, "MetricaLeft"));
        this.setMetricaTop(XMLGenerate.getValorBooleanFrom(me, "MetricaTop"));
        this.setMetricaDown(XMLGenerate.getValorBooleanFrom(me, "MetricaDown"));
        this.setMetricaRigth(XMLGenerate.getValorBooleanFrom(me, "MetricaRigth"));
        this.setMargem(XMLGenerate.getValorIntegerFrom(me, "Margem"));
        this.setCorRegua(XMLGenerate.getValorColorFrom(me, "CorRegua"));
        this.setCorBorda(XMLGenerate.getValorColorFrom(me, "CorBorda"));
        this.setPintarBorda(XMLGenerate.getValorBooleanFrom(me, "PintarBorda"));
        this.setMostrarTextoRegua(XMLGenerate.getValorBooleanFrom(me, "MostrarTextoRegua"));
        Element inter = XMLGenerate.FindByNodeName(me, "DrawerItens");
        if (inter != null) {
            for (int s = 0; s < inter.getChildNodes().getLength(); ++s) {
                Node fstNode = inter.getChildNodes().item(s);
                if (fstNode.getNodeType() != 1) continue;
                Element fstElmnt = (Element)fstNode;
                baseDrawerItem item = this.AddItem();
                if (item.LoadFromXML(fstElmnt, colando)) continue;
                return false;
            }
        }
        return true;
    }

    public String getUnidadeMedida() {
        return this.unidadeMedida;
    }

    public void setUnidadeMedida(String unidadeMedida) {
        if (this.unidadeMedida.equals(unidadeMedida)) {
            return;
        }
        this.unidadeMedida = unidadeMedida;
        this.InvalidateArea();
    }

    public int getProporcaoQtdPixel() {
        return this.proporcaoQtdPixel;
    }

    public void setProporcaoQtdPixel(int proporcaoQtdPixel) {
        if (this.proporcaoQtdPixel == proporcaoQtdPixel) {
            return;
        }
        this.proporcaoQtdPixel = proporcaoQtdPixel;
        if (this.proporcaoQtdPixel < 2) {
            this.proporcaoQtdPixel = 1;
        }
        this.InvalidateArea();
    }

    public int getProporcaoMedida() {
        return this.proporcaoMedida;
    }

    public void setProporcaoMedida(int proporcaoMedida) {
        if (this.proporcaoMedida == proporcaoMedida) {
            return;
        }
        this.proporcaoMedida = proporcaoMedida;
        if (this.proporcaoMedida < 2) {
            this.proporcaoMedida = 1;
        }
        this.InvalidateArea();
    }

    public boolean isMetricaLeft() {
        return this.metricaLeft;
    }

    public void setMetricaLeft(boolean metricaLeft) {
        if (this.metricaLeft == metricaLeft) {
            return;
        }
        this.metricaLeft = metricaLeft;
        this.InvalidateArea();
    }

    public boolean isMetricaTop() {
        return this.metricaTop;
    }

    public void setMetricaTop(boolean metricaTop) {
        if (this.metricaTop == metricaTop) {
            return;
        }
        this.metricaTop = metricaTop;
        this.InvalidateArea();
    }

    public boolean isMetricaDown() {
        return this.metricaDown;
    }

    public void setMetricaDown(boolean metricaDown) {
        if (this.metricaDown == metricaDown) {
            return;
        }
        this.metricaDown = metricaDown;
        this.InvalidateArea();
    }

    public boolean isMetricaRigth() {
        return this.metricaRigth;
    }

    public void setMetricaRigth(boolean metricaRigth) {
        if (this.metricaRigth == metricaRigth) {
            return;
        }
        this.metricaRigth = metricaRigth;
        this.InvalidateArea();
    }

    public String getWidthUnidMedida() {
        this.DimensioneParaPintura();
        return this.convertMedidas(this.W);
    }

    public void setWidthUnidMedida(String widthUnidMedida) {
        try {
            double res = Double.valueOf(widthUnidMedida.replace(',', '.'));
            int r = (int)Math.round(res * (double)this.proporcaoQtdPixel / (double)this.proporcaoMedida);
            this.setWidth(r + 2 * this.margem);
            this.Reposicione();
            this.PropagueResizeParaLigacoes();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getHeightUnidMedida() {
        this.DimensioneParaPintura();
        return this.convertMedidas(this.H);
    }

    public void setHeightUnidMedida(String heightUnidMedida) {
        try {
            double res = Double.valueOf(heightUnidMedida.replace(',', '.'));
            int r = (int)Math.round(res * (double)this.proporcaoQtdPixel / (double)this.proporcaoMedida);
            this.setHeight(r + 2 * this.margem);
            this.Reposicione();
            this.PropagueResizeParaLigacoes();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getMargem() {
        return this.margem;
    }

    public void setMargem(int margem) {
        if (this.margem == margem) {
            return;
        }
        if (margem > this.getWidth() / 2 || margem > this.getHeight() / 2 || margem < 0) {
            margem = 14;
        }
        this.margem = margem;
        this.InvalidateArea();
    }

    @Override
    public ArrayList<baseDrawerItem> getItens() {
        return this.Itens;
    }

    @Override
    public baseDrawerItem AddItem() {
        baseDrawerItem bi = new baseDrawerItem(this, baseDrawerItem.tipoDrawer.tpRetangulo);
        this.getItens().add(bi);
        return bi;
    }

    public void setItens(ArrayList<baseDrawerItem> Itens) {
        this.Itens = Itens;
    }

    @Override
    public int getL() {
        return this.L;
    }

    @Override
    public int getH() {
        return this.H;
    }

    @Override
    public int getT() {
        return this.T;
    }

    @Override
    public int getW() {
        return this.W;
    }

    @Override
    public String FormateUnidadeMedida(int valor) {
        return this.convertMedidas(valor) + this.getUnidadeMedida();
    }
}

