/*
 * Decompiled with CFR 0.152.
 */
package diagramas.conceitual;

import controlador.Diagrama;
import controlador.inspector.InspectorProperty;
import desenho.preAnyDiagrama.PreCardinalidade;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import util.XMLGenerate;

public class Cardinalidade
extends PreCardinalidade {
    private static final long serialVersionUID = -9219630166211153571L;

    public Cardinalidade(Diagrama modelo) {
        super(modelo);
        this.setCanBeDeleted(false);
        this.nodic = false;
    }

    public Cardinalidade(Diagrama modelo, String texto) {
        super(modelo, texto);
        this.setCanBeDeleted(false);
        this.nodic = false;
    }

    @Override
    public ArrayList<InspectorProperty> GenerateProperty() {
        ArrayList<InspectorProperty> res = super.GenerateProperty();
        String[] afetados = new String[]{"setWidth", "setHeight"};
        InspectorProperty tmp = InspectorProperty.FindByProperty(res, "setHeight");
        int p = res.indexOf(tmp) + 1;
        res.add(p, InspectorProperty.PropertyFactorySN("cardinalidade.tamanhoautmatico", "setTamanhoAutmatico", this.isTamanhoAutmatico()).AddCondicaoForFalse(afetados));
        res.add(p + 1, InspectorProperty.PropertyFactorySN("cardinalidade.movimentacaomanual", "setMovimentacaoManual", this.isMovimentacaoManual()));
        ArrayList<String> strCards = new ArrayList<String>();
        for (int i = 0; i < 4; ++i) {
            strCards.add(this.CardToString(this.IntToCard(i)));
        }
        res.add(InspectorProperty.PropertyFactoryMenu("cardinalidade.card", "setCard", this.CardToInt(), strCards));
        return res;
    }

    @Override
    protected void ToXmlValores(Document doc, Element me) {
        super.ToXmlValores(doc, me);
        me.appendChild(XMLGenerate.ValorBoolean(doc, "TamanhoAutmatico", this.isTamanhoAutmatico()));
        me.appendChild(XMLGenerate.ValorInteger(doc, "Card", this.CardToInt()));
        me.appendChild(XMLGenerate.ValorBoolean(doc, "MovimentacaoManual", this.isMovimentacaoManual()));
        me.appendChild(XMLGenerate.ValorString(doc, "Papel", this.getPapel()));
    }

    @Override
    public boolean LoadFromXML(Element me, boolean colando) {
        if (!super.LoadFromXML(me, colando)) {
            return false;
        }
        int l = XMLGenerate.getValorIntegerFrom(me, "Card");
        if (l != -1) {
            this.setCard(l);
        }
        this.setTamanhoAutmatico(XMLGenerate.getValorBooleanFrom(me, "TamanhoAutmatico"));
        this.setMovimentacaoManual(XMLGenerate.getValorBooleanFrom(me, "MovimentacaoManual"));
        this.setPapel(XMLGenerate.getValorStringFrom(me, "Papel"));
        return true;
    }

    @Override
    public boolean isAlinhavel() {
        return false;
    }
}

