/*
 * Decompiled with CFR 0.152.
 */
package diagramas.eap;

import controlador.Diagrama;
import controlador.inspector.InspectorProperty;
import desenho.formas.Forma;
import desenho.linhas.Linha;
import desenho.linhas.PontoDeLinha;
import desenho.preDiagrama.baseDrawerFromForma;
import diagramas.eap.EapBarraLigacao;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import util.DesenhadorDeTexto;
import util.XMLGenerate;

public class EapProcesso
extends baseDrawerFromForma {
    private static final long serialVersionUID = 7455235988018549136L;

    public EapProcesso(Diagrama diagrama) {
        super(diagrama);
        this.Inicie();
    }

    private void Inicie() {
        this.setRoundrect(0);
        this.setGradiente(true);
        this.setDelimite(false);
        this.setGradienteStartColor(new Color(255, 255, 255, 255));
    }

    public EapProcesso(Diagrama diagrama, String texto) {
        super(diagrama, texto);
        this.Inicie();
    }

    @Override
    public ArrayList<InspectorProperty> GenerateProperty() {
        ArrayList<InspectorProperty> res = super.GenerateProperty();
        InspectorProperty tmp = InspectorProperty.FindByProperty(res, "setTexto");
        tmp.ReSetCaptionFromConfig("nometexto");
        tmp.tipo = InspectorProperty.TipoDeProperty.tpTextoLongo;
        return res;
    }

    @Override
    public DesenhadorDeTexto getTextoFormatado() {
        DesenhadorDeTexto dz = super.getTextoFormatado();
        dz.setCentrarTextoVertical(true);
        dz.setCentrarTextoHorizontal(true);
        dz.CorretorPosicao = new Point(0, 0);
        return dz;
    }

    @Override
    public void PosicionePonto(PontoDeLinha ponto) {
        super.PosicionePonto(ponto);
        PontoDeLinha outraponta = ponto.getDono().getOutraPonta(ponto);
        if (outraponta.getEm() instanceof EapBarraLigacao) {
            outraponta.getEm().PosicionePonto(outraponta);
        }
    }

    @Override
    public boolean CanLiga(Forma forma, Linha lin) {
        if (super.CanLiga(forma, lin)) {
            return forma == null || forma instanceof EapBarraLigacao && forma.CanLiga(this, lin);
        }
        return false;
    }

    @Override
    protected void ToXmlValores(Document doc, Element me) {
        super.ToXmlValores(doc, me);
        me.appendChild(XMLGenerate.ValorColor(doc, "BackColor", this.getBackColor()));
        me.appendChild(XMLGenerate.ValorBoolean(doc, "Gradiente", this.isGradiente()));
        me.appendChild(XMLGenerate.ValorColor(doc, "GradienteStartColor", this.getGradienteStartColor()));
        me.appendChild(XMLGenerate.ValorColor(doc, "GradienteEndColor", this.getGradienteEndColor()));
        me.appendChild(XMLGenerate.ValorInteger(doc, "GDirecao", this.getGDirecao()));
    }

    @Override
    public boolean LoadFromXML(Element me, boolean colando) {
        Color c;
        if (!super.LoadFromXML(me, colando)) {
            return false;
        }
        int l = XMLGenerate.getValorIntegerFrom(me, "GDirecao");
        if (l != -1) {
            this.setGDirecao(l);
        }
        if ((c = XMLGenerate.getValorColorFrom(me, "BackColor")) != null) {
            this.setBackColor(c);
        }
        this.setGradiente(XMLGenerate.getValorBooleanFrom(me, "Gradiente"));
        c = XMLGenerate.getValorColorFrom(me, "GradienteStartColor");
        if (c != null) {
            this.setGradienteStartColor(c);
        }
        if ((c = XMLGenerate.getValorColorFrom(me, "GradienteEndColor")) != null) {
            this.setGradienteEndColor(c);
        }
        return true;
    }

    @Override
    public void PoluleColors(ArrayList<Color> cores) {
        super.PoluleColors(cores);
        if (cores.indexOf(this.getGradienteStartColor()) == -1) {
            cores.add(this.getGradienteStartColor());
        }
        if (cores.indexOf(this.getGradienteEndColor()) == -1) {
            cores.add(this.getGradienteEndColor());
        }
    }

    public EapBarraLigacao getOutraLigacao(EapBarraLigacao exceto) {
        ArrayList<Forma> lst = this.getListaDeFormasLigadas();
        lst.remove(exceto);
        if (lst.isEmpty()) {
            return null;
        }
        return (EapBarraLigacao)lst.get(0);
    }

    @Override
    public void DoPaint(Graphics2D g) {
        Composite bkp = g.getComposite();
        Paint p = g.getPaint();
        super.DoPaint(g);
        g.setPaint(p);
        g.setComposite(bkp);
    }
}

