/*
 * Decompiled with CFR 0.152.
 */
package diagramas.livre;

import controlador.Controler;
import controlador.Diagrama;
import controlador.Editor;
import desenho.Elementar;
import desenho.FormaElementar;
import desenho.formas.Desenhador;
import desenho.formas.Forma;
import desenho.formas.Legenda;
import desenho.preAnyDiagrama.PreLigacaoSeta;
import diagramas.atividade.TextoAtividade;
import diagramas.conceitual.Texto;
import diagramas.livre.LivreCirculo;
import diagramas.livre.LivreComentario;
import diagramas.livre.LivreDocumento;
import diagramas.livre.LivreDrawer;
import diagramas.livre.LivreJuncao;
import diagramas.livre.LivreLigacao;
import diagramas.livre.LivreLigacaoSimples;
import diagramas.livre.LivreLosango;
import diagramas.livre.LivreNota;
import diagramas.livre.LivreRetangulo;
import diagramas.livre.LivreRetanguloArr;
import diagramas.livre.LivreSuperTexto;
import diagramas.livre.LivreTextoApenso;
import diagramas.livre.LivreTriangulo;
import diagramas.livre.LivreVariosDocumentos;
import java.awt.Point;
import java.awt.Rectangle;
import org.w3c.dom.Document;

public class DiagramaLivre
extends Diagrama {
    private static final long serialVersionUID = 1440265007689102490L;
    private final Class[] classesDoDiagrama = new Class[]{LivreRetangulo.class, LivreRetanguloArr.class, LivreComentario.class, LivreDocumento.class, LivreVariosDocumentos.class, LivreNota.class, LivreTriangulo.class, LivreCirculo.class, LivreLosango.class, LivreSuperTexto.class, LivreLigacao.class, LivreLigacaoSimples.class, LivreJuncao.class, LivreTextoApenso.class, TextoAtividade.class, LivreDrawer.class, Texto.class, Desenhador.class, Legenda.class};

    public DiagramaLivre(Editor omaster) {
        super(omaster);
        this.setTipo(Diagrama.TipoDeDiagrama.tpLivre);
        this.meusComandos.add(Controler.Comandos.cmdLivreRetangulo.name());
        this.meusComandos.add(Controler.Comandos.cmdLivreRetanguloArr.name());
        this.meusComandos.add(Controler.Comandos.cmdLivreComentario.name());
        this.meusComandos.add(Controler.Comandos.cmdLivreDocumento.name());
        this.meusComandos.add(Controler.Comandos.cmdLivreNota.name());
        this.meusComandos.add(Controler.Comandos.cmdLivreTriangulo.name());
        this.meusComandos.add(Controler.Comandos.cmdLivreCirculo.name());
        this.meusComandos.add(Controler.Comandos.cmdLivreJuncao.name());
        this.meusComandos.add(Controler.Comandos.cmdLivreLosango.name());
        this.meusComandos.add(Controler.Comandos.cmdLivreSuperTexto.name());
        this.meusComandos.add(Controler.Comandos.cmdLivreLigacao.name());
        this.meusComandos.add(Controler.Comandos.cmdLivreLigacaoSimples.name());
        this.meusComandos.add(Controler.Comandos.cmdLivreVariosDocumentos.name());
        this.meusComandos.add(Controler.Comandos.cmdLivreDrawer.name());
    }

    @Override
    public Class[] getCassesDoDiagrama() {
        return this.classesDoDiagrama;
    }

    @Override
    protected FormaElementar RealiseComando(Point posi) {
        this.ClearSelect(false);
        FormaElementar resu = null;
        Controler.Comandos com = this.getComando();
        switch (com) {
            case cmdLivreRetangulo: {
                LivreRetangulo lr = new LivreRetangulo(this, LivreRetangulo.class.getSimpleName());
                lr.SetBounds(posi.x, posi.y, 120, 58);
                lr.Reenquadre();
                resu = lr;
                break;
            }
            case cmdLivreRetanguloArr: {
                LivreRetanguloArr lra = new LivreRetanguloArr(this, LivreRetanguloArr.class.getSimpleName());
                lra.SetBounds(posi.x, posi.y, 120, 58);
                lra.Reenquadre();
                resu = lra;
                break;
            }
            case cmdLivreComentario: {
                LivreComentario lco = new LivreComentario(this, LivreComentario.class.getSimpleName());
                lco.SetBounds(posi.x, posi.y, 120, 58);
                lco.Reenquadre();
                resu = lco;
                break;
            }
            case cmdLivreDocumento: {
                LivreDocumento ld = new LivreDocumento(this, LivreDocumento.class.getSimpleName());
                ld.SetBounds(posi.x, posi.y, 120, 58);
                ld.Reenquadre();
                resu = ld;
                break;
            }
            case cmdLivreVariosDocumentos: {
                LivreVariosDocumentos lds = new LivreVariosDocumentos(this, LivreVariosDocumentos.class.getSimpleName());
                lds.SetBounds(posi.x, posi.y, 120, 58);
                lds.Reenquadre();
                resu = lds;
                break;
            }
            case cmdLivreNota: {
                LivreNota ln = new LivreNota(this, LivreNota.class.getSimpleName());
                ln.SetBounds(posi.x, posi.y, 120, 80);
                ln.Reenquadre();
                resu = ln;
                break;
            }
            case cmdLivreCirculo: {
                LivreCirculo llc = new LivreCirculo(this, LivreCirculo.class.getSimpleName());
                llc.SetBounds(posi.x, posi.y, 60, 60);
                llc.Reenquadre();
                resu = llc;
                break;
            }
            case cmdLivreJuncao: {
                LivreJuncao llj = new LivreJuncao(this, LivreJuncao.class.getSimpleName());
                llj.SetBounds(posi.x, posi.y, 30, 30);
                llj.Reenquadre();
                resu = llj;
                break;
            }
            case cmdLivreTriangulo: {
                LivreTriangulo llt = new LivreTriangulo(this, LivreTriangulo.class.getSimpleName());
                llt.SetBounds(posi.x, posi.y, 30, 30);
                llt.Reenquadre();
                resu = llt;
                break;
            }
            case cmdLivreLosango: {
                LivreLosango ll = new LivreLosango(this, LivreLosango.class.getSimpleName());
                ll.SetBounds(posi.x, posi.y, 100, 40);
                ll.Reenquadre();
                resu = ll;
                break;
            }
            case cmdLivreSuperTexto: {
                LivreSuperTexto lst = new LivreSuperTexto(this, LivreSuperTexto.class.getSimpleName());
                lst.SetBounds(posi.x, posi.y, 120, 20);
                lst.Reenquadre();
                resu = lst;
                break;
            }
            case cmdLivreDrawer: {
                LivreDrawer ldw = new LivreDrawer(this, LivreDrawer.class.getSimpleName());
                ldw.SetBounds(posi.x, posi.y, 250, 150);
                ldw.Reenquadre();
                resu = ldw;
                break;
            }
            case cmdLivreLigacao: 
            case cmdLivreLigacaoSimples: {
                if (this.cliq1 == null) {
                    Elementar res = this.CaptureFromPoint(posi);
                    FormaElementar obj1 = null;
                    if (res instanceof FormaElementar) {
                        obj1 = (FormaElementar)res;
                    }
                    this.cliq1 = new Diagrama.clickForma(obj1, posi);
                    return null;
                }
                if (this.cliq2 == null) {
                    FormaElementar obj2 = null;
                    Elementar res = this.CaptureFromPoint(posi);
                    if (res instanceof FormaElementar) {
                        obj2 = (FormaElementar)res;
                    }
                    this.cliq2 = new Diagrama.clickForma(obj2, posi);
                }
                PreLigacaoSeta linha = com == Controler.Comandos.cmdLivreLigacao ? new LivreLigacao(this) : new LivreLigacaoSimples(this);
                resu = linha;
                Point pt1 = this.cliq1.getPonto();
                Point pt2 = this.cliq2.getPonto();
                if (this.cliq1.getForma() instanceof LivreTriangulo || this.cliq2.getForma() instanceof LivreTriangulo) {
                    linha.setInteligente(false);
                }
                if (this.CaptureFromPoint(pt1) instanceof LivreLigacao) {
                    this.Emende((LivreLigacao)this.CaptureFromPoint(pt1), pt1);
                    linha.setInteligente(false);
                }
                if (this.CaptureFromPoint(pt1) instanceof LivreLigacaoSimples) {
                    this.Emende((LivreLigacaoSimples)this.CaptureFromPoint(pt1), pt1);
                    linha.setInteligente(false);
                }
                if (this.CaptureFromPoint(pt2) instanceof LivreLigacao) {
                    this.Emende((LivreLigacao)this.CaptureFromPoint(pt2), pt2);
                    linha.setInteligente(false);
                }
                if (this.CaptureFromPoint(pt2) instanceof LivreLigacaoSimples) {
                    this.Emende((LivreLigacaoSimples)this.CaptureFromPoint(pt2), pt2);
                    linha.setInteligente(false);
                }
                linha.Inicie(new Rectangle(pt2.x, pt2.y, pt1.x - pt2.x, pt1.y - pt2.y));
                linha.reSetBounds();
                linha.repaint();
            }
        }
        if (resu == null) {
            resu = super.RealiseComando(posi);
            if (resu instanceof Texto) {
                ((Texto)resu).setSimplesDezenho(false);
            } else if (resu instanceof Desenhador) {
                ((Desenhador)resu).setSimplesDezenho(false);
            }
        } else {
            this.cliq1 = null;
            this.cliq2 = null;
            if (!this.master.isControlDown()) {
                this.setComando(null);
            } else {
                this.setComando(com);
            }
            resu.BringToFront();
        }
        return resu;
    }

    private void Emende(LivreLigacao lig, Point posi) {
        LivreJuncao jun = new LivreJuncao(this, LivreJuncao.class.getSimpleName());
        jun.SetBounds(posi.x - 15, posi.y - 15, 30, 30);
        jun.Reenquadre();
        Point fim = lig.getPontaA().getCentro();
        Forma f = lig.getPontaA().getEm();
        lig.SetInteligente(false);
        lig.getPontaA().LigarA(jun);
        lig.setTemSetaPontaB(false);
        lig = new LivreLigacao(this);
        lig.setInteligente(false);
        Point F = new Point(posi.x - 2, posi.y);
        lig.Inicie(new Rectangle(F.x, F.y, fim.x - F.x, fim.y - F.y));
        lig.getPontaA().LigarA(f);
        lig.setTemSetaPontaB(false);
    }

    private void Emende(LivreLigacaoSimples lig, Point posi) {
        LivreJuncao jun = new LivreJuncao(this, LivreJuncao.class.getSimpleName());
        jun.SetBounds(posi.x - 15, posi.y - 15, 30, 30);
        jun.Reenquadre();
        Point fim = lig.getPontaA().getCentro();
        Forma f = lig.getPontaA().getEm();
        lig.SetInteligente(false);
        lig.getPontaA().LigarA(jun);
        lig.setTemSetaPontaB(false);
        lig = new LivreLigacaoSimples(this);
        lig.setInteligente(false);
        Point F = new Point(posi.x - 2, posi.y);
        lig.Inicie(new Rectangle(F.x, F.y, fim.x - F.x, fim.y - F.y));
        lig.getPontaA().LigarA(f);
        lig.setTemSetaPontaB(false);
    }

    @Override
    public boolean LoadFromXML(Document doc, boolean colando) {
        boolean res = super.LoadFromXML(doc, colando);
        this.getListaDeItens().stream().filter(resu -> resu instanceof Texto).map(te -> (Texto)te).forEach(te -> te.setSimplesDezenho(false));
        this.getListaDeItens().stream().filter(resu -> resu instanceof Desenhador).map(de -> (Desenhador)de).forEach(de -> de.setSimplesDezenho(false));
        return res;
    }
}

