/*
 * Decompiled with CFR 0.152.
 */
package util;

import controlador.Diagrama;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.image.BufferedImage;

public class ImageGenerate {
    public static BufferedImage CriarImagem(int w, int h) {
        int type = 2;
        if (w < 1) {
            w = 1;
        }
        if (h < 1) {
            h = 1;
        }
        BufferedImage image = new BufferedImage(w, h, type);
        return image;
    }

    public static BufferedImage[] SplitImagens(BufferedImage img, int resImgW, int resImgH, int pgW, int pgH, int tl_pg) {
        BufferedImage[] res = new BufferedImage[tl_pg];
        int posW = 0;
        int posH = 0;
        int i = 0;
        for (int l = 0; l < pgH; ++l) {
            for (int c = 0; c < pgW; ++c) {
                BufferedImage tmp = img.getSubimage(posW, posH, resImgW, resImgH);
                res[i++] = tmp;
                posW += resImgW;
            }
            posW = 0;
            posH += resImgH;
        }
        return res;
    }

    public static BufferedImage geraImagem(Diagrama diag) {
        Point p = diag.getPontoExtremo();
        p = new Point(Math.max(p.x, 2), Math.max(p.y, 2));
        return ImageGenerate.geraImagemForPrn(diag, p.x, p.y);
    }

    public static BufferedImage geraImagemForPrn(Diagrama diag, int wdt, int ht) {
        BufferedImage res = ImageGenerate.CriarImagem(wdt, ht);
        Graphics2D g = (Graphics2D)res.getGraphics();
        g.setPaint(diag.getBackground());
        g.fillRect(0, 0, wdt, ht);
        diag.ExternalPaint(g);
        g.dispose();
        return res;
    }

    public static BufferedImage geraImagemForPrnSelecao(Diagrama diag, int wdt, int ht) {
        BufferedImage res = ImageGenerate.CriarImagem(wdt, ht);
        Graphics2D g = (Graphics2D)res.getGraphics();
        g.setPaint(diag.getBackground());
        g.fillRect(0, 0, wdt, ht);
        diag.ExternalPaintSelecao(g);
        g.dispose();
        return res;
    }
}

